(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('UserFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory',
    function($http, $log, $q, $location, SystemMessaging)
    {
        var urlBase = '/wstr/api/user';
        var exports = ['id', 'name', 'homephone', 'cellphone', 'email', 'rate', 'username', 'numlogins',
            'lastlog', 'status', 'create_date', 'modify_date', 'passwordchangerequired', 'organization_constitutional',
            'organization_spirits', 'is_admin', 'new_password','password_verify','password'
        ];

        /* can use prototypical inheritance, and object can behave like a real object and not just a dictionary */
        function User()
        {
            this.id = this.name = this.homephone = this.cellphone = this.email = this.rate = this.username =
                this.numlogins = this.lastlog = this.status = this.create_date = this.modify_date =
                    this.passwordchangerequired = this.organization_constitutional = this.organization_spirits =
                        this.fullName = null;

            this.passwordchangerequired = 0;
            this.isLoaded = false;
            this.isLoading = false;
            this.isSaving = false;
            this.keepalive = 1;
            this.is_admin = 0;
            this.new_password = null;
            this.password_verify = null;
            this.type = 'User';
            this.change_password = 0;
        }

        User.prototype.postLoad = function()
        {
            if (this.change_password/1 === 1)
            {
                $location.url('/new-password');
            }

            if (window.location.hash === '')
            {
                if (this.is_admin)
                {
                    $location.path('/admin/calendar');
                } else
                {
                    $location.path('/calendar');
                }
            }

            return $q.all([]);
        };

        User.prototype.load = function(supressError, skipPost)
        {
            if (this.isLoaded) { return $q.all([]); }

            var self = this;

            var url = "";

            if (this.isLoaded && !skipPost)
            {
                return this.postLoad();
            }

            if      (this.id !== null && this.id !== 0)              { url = urlBase + '/' + this.id;    }
            else if (this.username !== null && this.username !== '') { url = urlBase + '/' + this.username; }
            else                                                     { url = urlBase + '/' + 'active';   }

            return $http({
                method : 'GET',
                url : url
            }).then(function(response)
            {
                if (!supressError)
                {
                    SystemMessaging.sendMessage(response.data);
                }
                self.hydrate(response.data);
                if (!skipPost) { self.postLoad(); }
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        User.prototype.reload = function()
        {
            this.isLoaded = false;
            return this.load(false, true);
        };

        User.prototype.buildPostData = function(updatePassword)
        {
            var postData = {};

            var self = this;

            if (self.id === 'newuser') { self.id = null; }

            for (var idx in exports)
            {
                var property = exports[idx];
                postData[property] = self[property];

                if (['status', 'organization_constitutional', 'organization_spirits'].indexOf(property) >= 0)
                {
                    postData[property] = postData[property] ? 1 : 0;
                }
            }

            if (updatePassword)
            {
                postData.password = self.password;
                postData.new_password = self.new_password;
                postData.password_verify = self.password_verify;
            }

            return postData;
        };

        User.prototype.save = function(updatePassword)
        {
            var self = this;
            this.isSaving = this.isLoading = true;

            var postData = this.buildPostData(updatePassword);

            return $http({
                method : this.id !== undefined && this.id !== null ? 'PUT' : 'POST',
                url    : this.id !== undefined && this.id !== null ? urlBase + '/' + this.id : urlBase,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                data   : $.param( postData )
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                    self.hydrate(response.data);
                    self.isSaving = self.isLoading = false;
                    return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };
         
        User.prototype.accountUpdate = function()
        {
            var self = this;
            var postData = {};

            for (var idx in exports)
            {
                if (!exports.hasOwnProperty(idx)) { continue; }

                var property = exports[idx];
                postData[property] = this[property];
            }
            postData.password = this.password;
            postData.new_password = this.new_password;
            postData.password_verify = this.password_verify;

            return $http({
                method : 'PUT',
                url : urlBase + '/' + this.id,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' },
                data   : $.param( postData )
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                if (response.data.errors !== undefined)
                {
                    return response.data.errors;
                }
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        User.prototype.hydrate = function(data)
        {
            for (var property in data)
            {
                if (!data.hasOwnProperty(property)) { continue; }

                this[property] = data[property];

                if (['id', 'rate', 'numlogins'].indexOf(property) >= 0)
                {
                    this[property] /= 1;
                }

                if (['lastlog', 'create_date', 'modify_date'].indexOf(property) >= 0)
                {
                    this[property] = new Date(this[property]);
                }

                if (['passwordchangerequired', 'organization_constitutional', 'organization_spirits',
                     'is_admin', 'status'].indexOf(property) >= 0)
                {
                    this[property] = data[property]/1 === 1;
                }

            }
            if (this.name && this.name.match(' '))
            {
                var name = this.name.split(" ");
                this.fullName = name.pop() + ', ' + name.shift();
                this.fullName += name.length > 0 ? ' ' + name.shift() : '';
            } else
            {
                this.fullName = this.name;
            }
            this.isLoaded = true;
            this.isLoading = false;
        };

        User.prototype.deleteUser = function()
        {
            return $http({
                method : "DELETE",
                url    : urlBase + '/' + this.id ,
                headers : { 'Content-Type' : 'application/x-www-form-urlencoded' }
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.isSaving = self.isLoading = false;
                return false;
            });
        };

        User.prototype.passwordOkay = function()
        {
            return (this.new_password && this.password_verify) &&
                   this.new_password === this.password_verify &&
                   this.new_password.length >= 8 &&
                   this.new_password.match(/[a-z]{1,}/) &&
                   this.new_password.match(/[A-Z]{1,}/) &&
                   this.new_password.match(/[0-9]{1,}/) &&
                   this.new_password.match(/[\W]{1,}/);

        };

        User.prototype.firstName = function()
        {
            return this.name.split(' ').shift();
        };

        User.prototype.lastName = function()
        {
            return this.name.split(' ').pop();
        };

        return User;

    }]);

})(jQuery, angular, document, window);
