(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('TicketTypeCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'TicketTypeFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, SystemMessaging, TicketType, AppModelCollectionFactory)
    {


        function TicketTypeCollection()
        {
            var self = this;

            this.urlBase = '/wstr/api/ticket-types';

            this.collection = [];

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.hydrateCallback = function(modelData)
            {
                var ticketType = new TicketType();
                ticketType.hydrate(modelData);

                return ticketType;
            };
        }

        TicketTypeCollection.prototype = AppModelCollectionFactory.prototype;

        return new TicketTypeCollection();
    }]);
    
})(jQuery, angular, document, window);