(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('TicketTypeFactory',
        ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
         function($http, $log, $q, $location, SystemMessaging, AppModelFactory)
         {

             function TicketType()
             {
                 var self = this;

                 this.urlBase = '/wstr/api/ticket-types';
                 this.exports = ['id', 'name', 'abbrv', 'organization_id', 'adult', 'child', 'combined', 'status'];

                 this.id = this.name = this.abbrv = this.organization_id = this.adult = this.child =
                     this.combined = this.status = null;

                 this.constitutional = true;
                 this.spirits = true;

                 this.propertyTypes = {
                     number : ['id', 'organization_id'],
                     bool   : ['adult', 'child', 'combined', 'status'],
                     time   : []
                 };

                 this.getSaveUrl = function ()
                 {
                     return self.id !== undefined && self.id !== null ?
                            self.urlBase + '/' + self.id : self.urlBase;
                 };

                 this.getSaveMethod = function()
                 {
                     return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
                 };

                 this.getLoadUrl = function()
                 {
                     return self.urlBase;
                 };

                 this.getDeleteUrl = function()
                 {
                     return self.urlBase + '/' + self.id;
                 };

                 this.hydrateCallback = function(property)
                 {
                     if (property === 'organization_id')
                     {
                         if (self[property]/1 === 1)
                         {
                             self.constitutional = true;
                             self.spirits = false;
                         }
                         if (self[property]/1 === 2)
                         {
                             self.spirits = true;
                             self.constitutional = false;
                         }
                     }
                 };

             }

             TicketType.prototype = AppModelFactory.prototype;

             return TicketType;

         }]);
})(jQuery, angular, document, window);
