(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('TaskAssignmentFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
    function($http, $log, $q, $location, SystemMessaging, AppModel)
    {

        function TaskAssignment()
        {
            var self = this;


            this.id = this.shiftassignment_id = this.guide_id = this.organization_id = this.task_id =
                this.tasktype = this.assignmentdate = this.starttime = this.endtime = this.tourtype =
                this.numpersonsontour = this.tourcontactname = this.tourcontactphone = this.tourcontactemail =
                this.notes = this.status = this.createdate = this.modifydate = this.numguidesrequired =
                this.tourname = this.paymentstatus = this.paymentnotes = this.confirmationemaildate =
                this.thankyouemailto = this.thankyouemaildate = this.leadguidegivingtour = null;

            this.urlBase = '/wstr/api/task-assignment';

            this.exports = [ 'id', 'shiftassignment_id', 'guide_id', 'organization_id', 'task_id',
                'tasktype', 'assignmentdate', 'starttime', 'endtime', 'tourtype', 'numpersonsontour',
                'tourcontactname', 'tourcontactphone', 'tourcontactemail', 'notes', 'status',
                'createdate', 'modifydate', 'numguidesrequired', 'tourname', 'paymentstatus',
                'paymentnotes', 'confirmationemaildate', 'thankyouemailto', 'thankyouemaildate',
                'leadguidegivingtour'
            ];

            this.propertyTypes = {
                number : ['id', 'shiftassignment_id', 'guide_id', 'organization_id', 'task_id',
                          'tasktype', 'tourtype', 'numpersonsontour', 'numguidesrequired',
                          'leadguidegivingtour'],
                bool   : ['status', 'leadguidegivingtour'],
                time   : ['starttime', 'endtime']
            };

            this.getSaveUrl = function ()
            {
                return self.id !== undefined && self.id !== null ?
                    self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getSaveMethod = function()
            {
                return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
            };

            this.getLoadUrl = function()
            {
                return self.id !== undefined && self.id !== null ?
                       self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getDeleteUrl = function()
            {
                return self.urlBase + '/' + self.id;
            };

            this.buildCallback = function(property, model)
            {
            };

            this.start_hour = this.start_minute = this.end_hour = this.end_minute;

            this.hydrateCallback = function(property)
            {
                switch (property)
                {
                    case 'starttime':
                        self.start_hour = self.starttime.getHours();
                        self.start_minute = self.starttime.getMinutes();
                        break;
                    case 'endtime':
                        self.end_hour = self.endtime.getHours();
                        self.end_minute = self.endtime.getMinutes();
                        break;
                    case 'confirmationemaildate':
                        self.confirmationemaildate = self.confirmationemaildate ? new Date(self.confirmationemaildate) : null;
                        break;
                    case 'thankyouemaildate':
                        self.thankyouemaildate = self.thankyouemaildate ? new Date(self.thankyouemaildate) : null;
                        break;
                }
            };

            this.postHydrateCallback = function()
            {
                self.updateTimes();
            };

            this.updateTimes = function()
            {

                var assignmentDate = new Date(self.assignmentdate + " 00:00:00");

                self.starttime = new Date(assignmentDate);
                self.endtime   = new Date(assignmentDate);

                self.start_hour   = self.start_hour   ? self.start_hour   : 6;
                self.start_minute = self.start_minute ? self.start_minute : 0;
                self.end_hour     = self.end_hour     ? self.end_hour     : self.start_hour + 1;
                self.end_minute   = self.end_minute   ? self.end_minute   : 0;

                self.starttime.setYear(assignmentDate.getFullYear());
                self.starttime.setMonth(assignmentDate.getMonth());
                self.starttime.setDate(assignmentDate.getDate());
                self.starttime.setHours(self.start_hour);
                self.starttime.setMinutes(self.start_minute);
                self.starttime.setSeconds(0);
                self.starttime.setMilliseconds(0);

                self.endtime.setYear(assignmentDate.getFullYear());
                self.endtime.setMonth(assignmentDate.getMonth());
                self.endtime.setDate(assignmentDate.getDate());
                self.endtime.setHours(self.end_hour);
                self.endtime.setMinutes(self.end_minute);
                self.endtime.setSeconds(0);
                self.endtime.setMilliseconds(0);
            };

            this.getScheduledMinutes = function()
            {
                return (self.getSecondsScheduled() / 60) % 60;
            };

            this.getScheduledHours = function()
            {
                return Math.trunc(self.getSecondsScheduled() / 60 / 60);
            };

            this.getSecondsScheduled = function()
            {
                return self.starttime && self.endtime ? (self.endtime - self.starttime)/1000 : 0;
            };

            this.getThankYouMessageSubject = function()
            {
                var $subject = null;

                switch (self.organization_id)
                {
                    case 1: $subject = 'Thanks for Taking The Constitutional Walking Tour'; break;
                    case 2: $subject = 'Thanks for Taking The Spirits of \'76 Ghost Tour'; break;
                }

                if (self.tourtype/1 === 6)
                {
                    $subject = 'Thanks for Taking The Constitutional Virtual Tour';
                }
                if (self.tourtype/1 === 5)
                {
                    $subject = 'Thanks for Taking The Constitutional Bus Tour';
                }

                if (self.tourtype/1 === 9 || self.tourtype/1 === 10)
                {
                    $subject = 'Thanks for Taking The Constitutional Scavenger Hunt';
                }

                return $subject;
            };

            this.getConfirmationMessageSubject = function()
            {
                var $subject = null;

                switch (self.organization_id)
                {
                    case 1: $subject = 'Tour Details - The Constitutional Walking Tour'; break;
                    case 2: $subject = 'Tour Details - Spirits of \'76 Ghost Tour'; break;
                }

                if (self.tourtype === 5)
                {
                    $subject = 'Tour Details - The Constitutional Bus Tour';
                }
                if (self.tourtype === 9)
                {
                    $subject = 'Tour Details - The Constitutional Scavenger Hunt';
                }

                return $subject;
            };


            this.getThankYouTemplateKey = function()
            {
                var $template_key = null;

                switch (self.tourtype)
                {
                    case 2:
                    case 4:
                        $template_key = self.organization_id/1 === 1 ? 'thankyouemail_const_groupschool' : 'thankyouemail_spirits_groupschool';
                        break;
                    case 3:
                        $template_key = self.organization_id/1 === 1 ? 'thankyouemail_const_vip' : 'thankyouemail_spirits_vip';
                        break;
                    case 5:
                        $template_key = 'thankyouemail_const_bus';
                        break;
                    case 9:
                    case 10:
                        $template_key = 'thankyouemail_const_scavengerhunt';
                        break;
                    case 15:
                        $template_key = 'thankyouemail_const_yf';
                        break;
                    case 6:
                    case 16:
                        $template_key = 'thankyouemail_virtual';
                        break;
                    default:
                        $template_key = 'thankyouemail_generic';
                        break;
                }

                return $template_key;
            };

            this.getConfirmationTemplateKey = function()
            {
                var $template_key = null;

                switch (self.tourtype)
                {
                    case 2 :
                    case 4 :
                        $template_key = this.organization_id/1 === 1 ? 'confirmation_const_groupschool' : 'confirmation_spirits_groupschool';
                        break;
                    case 3 :
                        $template_key = this.organization_id/1 === 1 ? 'confirmation_const_vip' : 'confirmation_spirits_vip';
                        break;
                    case 5 :
                        $template_key = 'confirmation_const_bus';
                        break;
                    case 9 :
                    case 10:
                        $template_key = 'confirmation_const_scavengerhunt';
                        break;
                    case 15:
                        $template_key = 'confirmation_const_yf';
                        break;
                    case 6:
                    case 16:
                        $template_key = 'confirmation_virtual';
                        break;
                    default:
                        $template_key = 'confirmation_generic';
                        break;

                }
                return $template_key;
            };


        }

        TaskAssignment.prototype = AppModel.prototype;


        return TaskAssignment;

    }]);

})(jQuery, angular, document, window);
