(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .factory('SystemMessagingFactory', ['notify', '$location', '$sanitize', function(growl, $location, $sanitize)
    {
        function SystemMessaging()
        {
        }

        SystemMessaging.prototype.server_errors = [
            'access_denied_exception', 'deleted_entry_notification_exception', 'entry_not_found_exception', 'exception',
            'system_error_exception', 'unauthorized_exception', 'email_sent_notification_exception'
        ];

        SystemMessaging.prototype.sendMessage = function(notification)
        {

            var redirectUser = function()
            {
                alert("You have been automatically logged out due to inactivity.");
                window.location.href = '/wstr/application/logout';
            };

            for (var key in notification)
            {
                if (!notification.hasOwnProperty(key)) { continue; }

                if (this.server_errors.indexOf(key) !== -1)
                {
                    var prefix = 'Server Message';
                    var classes = 'alert alert-warning';
                    if (key === 'system_error_exception')
                    {
                        classes = 'alert alert-danger';
                        prefix = 'Server Exception';
                    }
                    if (key === 'email_sent_notification_exception')
                    {
                        classes = 'alert alert-success';
                        prefix = 'Email Message Sent';
                    }
                    growl({
                        classes : classes,
                        position : "right",
                        duration : 30000, // stay alive for 30 seconds
                        message : prefix + ": \n\n" + notification[key]
                    });

                    if (key === 'unauthorized_exception')
                    {
                        setTimeout(redirectUser, 1500);
                    }

                    return true;
                }


            }

            return false;
        };

        return new SystemMessaging();
    }]);

})(jQuery, angular, document, window);
