(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('ShiftsCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'ShiftFactory',
    function ($http, $log, $q, SystemMessaging, Shift)
    {
        var urlBase = '/wstr/api/shifts';

        function ShiftsCollection()
        {
            this.isLoaded = false;
            this.shifts = [];
        }

        ShiftsCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        ShiftsCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var shiftData = data[i];
                var shiftObject = new Shift();
                shiftObject.hydrate(shiftData);
                this.shifts.push(shiftObject);
            }
            this.isLoaded = true;
        };

        ShiftsCollection.prototype.deleteShift = function(shift)
        {
            var found = this.shifts.filter(function(element)
            {
                return element.id/1 !== shift.id/1;
            });
            this.shifts = found;

            return shift.deleteShift();
        };

        return new ShiftsCollection();
    }]);
    
})(jQuery, angular, document, window);