(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('SeasonsCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'SeasonFactory',
    function ($http, $log, $q, SystemMessaging, Season)
    {
        var urlBase = '/wstr/api/seasons';

        function SeasonsCollection()
        {
            this.isLoaded = false;
            this.seasons = [];
        }

        SeasonsCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        SeasonsCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var seasonData = data[i];
                var seasonObject = new Season();
                seasonObject.hydrate(seasonData);
                this.seasons.push(seasonObject);
            }
            this.isLoaded = true;
        };

        SeasonsCollection.prototype.deleteSeason = function(season)
        {
            var found  = this.seasons.filter(function(element)
            {
                return element.id/1 !== season.id/1;
            });
            this.seasons = found;

            return season.deleteSeason();
        };

        return new SeasonsCollection();
    }]);
    
})(jQuery, angular, document, window);