(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('OrganizationsCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'OrganizationFactory',
    function ($http, $log, $q, SystemMessaging, Organization)
    {
        var urlBase = '/wstr/api/organizations';

        function OrganizationsCollection()
        {
            this.isLoaded = false;
            this.organizations = [];
        }

        OrganizationsCollection.prototype.load = function()
        {
            var self = this;

            if (this.isLoaded) { return $q.all([]); }

            return $http({
                method : 'GET',
                url : urlBase
            }).then(function(response)
            {
                SystemMessaging.sendMessage(response.data);
                self.hydrate(response.data);
                return self;
            }, function(response)
            {
                SystemMessaging.sendMessage(response.data);
                return self;
            });
        };

        OrganizationsCollection.prototype.hydrate = function(data)
        {
            for (var i in data)
            {
                var organizationData = data[i];
                var organizationObject = new Organization();
                organizationObject.hydrate(organizationData);
                this.organizations.push(organizationObject);
            }
            this.isLoaded = true;
        };

        OrganizationsCollection.prototype.deleteOrganization = function(organization)
        {
            var found = this.organizations.filter(function(element)
            {
                return element.id/1 !== organization.id/1;
            });
            this.organizations = found;

            return organization.deleteOrganization();
        };

        OrganizationsCollection.prototype.getOrganization = function(id)
        {
            return (this.organizations.filter(function(organization)
            {
                return organization.id/1 === id/1;
            })).pop();
        };


        return new OrganizationsCollection();
    }]);
    
})(jQuery, angular, document, window);