(function($, angular, document, window)
{
    var exports = ['navigation','secondaryNav'];
    var $http, $q, $log, $routeProvider;

    function Navigation()
    {
        this.navigation = [{
            title : 'Calendar',
            url : '/calendar',
            templateUrl : '/wstr/application/partials/calendar',
            controller : 'CalendarController',
            id : 1,
            skip : false,
            badge : 'mr-2 fa fa-calendar',
            admin : false,
            noadmin : true
        },{
            title : 'Calendar',
            url : '/admin/calendar',
            templateUrl : '/wstr/application/partials/admin-calendar',
            controller : 'AdminCalendarController',
            id : 1,
            skip : false,
            badge : 'mr-2 fa fa-calendar',
            admin : true,
            noadmin : false
        },{
            title : 'Tour Emails',
            url : '/admin/tour-email',
            templateUrl : '/wstr/application/partials/tour-email',
            controller : 'TourEmailController',
            id : 100,
            skip : true,
            badge : 'mr-2 fa fa-calendar',
            admin : true,
            noadmin : false
        },{
            title : 'Contact Guides',
            url : '/admin/contact-guides',
            templateUrl : '/wstr/application/partials/contact-guides',
            controller : 'ContactGuidesController',
            id : 101,
            skip : true,
            badge : 'mr-2 fa fa-calendar',
            admin : true,
            noadmin : false
        },{
            title : 'Task Assignment',
            url : '/admin/edit-task',
            templateUrl : '/wstr/application/partials/admin-manage-task',
            controller : 'AdminTaskManagerController',
            id : 102,
            skip : true,
            badge : 'mr-2 fa fa-calendar',
            admin : true,
            noadmin : false
        },{
            title : 'Day Details',
            url : '/admin/day-details',
            templateUrl : '/wstr/application/partials/admin-day-details',
            controller : 'AdminDayDetailsController',
            id : 103,
            skip : true,
            badge : 'mr-2 fa fa-calendar',
            admin : true,
            noadmin : false
        },{
            title : 'Day Details',
            url : '/day-details',
            templateUrl : '/wstr/application/partials/day-details',
            controller : 'DayDetailsController',
            id : 103,
            skip : true,
            badge : 'mr-2 fa fa-calendar',
            admin : false,
            noadmin : false
        },{
            title : 'Task List',
            url : '/admin/task-list',
            templateUrl : '/wstr/application/partials/admin-task-list',
            controller : 'AdminTaskListController',
            id : 104,
            skip : true,
            badge : 'mr-2 fa fa-calendar',
            admin : true,
            noadmin : false
        },{
            title : 'Seasons',
            url : '/admin/seasons',
            templateUrl : '/wstr/application/partials/seasons',
            controller : 'SeasonsController',
            id : 2,
            skip : false,
            badge : 'mr-2 fa fa-calendar-o',
            admin : true,
            noadmin : false
        },{
            title : 'Day Types',
            url : '/admin/day-types',
            templateUrl : '/wstr/application/partials/day-types',
            controller : 'DayTypesController',
            id : 3,
            skip : false,
            badge : 'mr-2 fa fa-cubes',
            admin : true,
            noadmin : false
        },{
            title : 'Guides',
            url : '/admin/guides',
            templateUrl : '/wstr/application/partials/guides',
            controller : 'GuidesController',
            id : 4,
            skip : false,
            badge : 'mr-2 fa fa-user-circle-o',
            admin : true,
            noadmin : false
        },{
            title : 'Save The Date',
            url : '/admin/save-the-date',
            templateUrl : '/wstr/application/partials/save-the-date',
            controller : 'SaveTheDateController',
            id : 5,
            skip : false,
            badge : 'mr-2 fa fa-calendar-check-o',
            admin : true,
            noadmin : false
        },{
            title : 'Time Sheets',
            url : '/time-sheets',
            templateUrl : '/wstr/application/partials/time-sheets',
            controller : 'TimeSheetsController',
            id : 6,
            skip : false,
            badge : 'mr-2 fa fa-clock-o',
            admin : false,
            noadmin : true
        },{
            title : 'Time Sheets',
            url : '/admin/time-sheets',
            templateUrl : '/wstr/application/partials/admin-time-sheets',
            controller : 'AdminTimeSheetsController',
            id : 6,
            skip : false,
            badge : 'mr-2 fa fa-clock-o',
            admin : true,
            noadmin : false
        },{
            title : 'Ticket Reconciliation',
            url : '/admin/ticket-reconciliation',
            templateUrl : '/wstr/application/partials/ticket-reconciliation',
            controller : 'TicketReconciliationController',
            id : 7,
            skip : false,
            badge : 'mr-2 zmdi zmdi-ticket-star zmdi-hc-fw',
            admin : true,
            noadmin : false
        },{
            title : 'Ticket Breakdown',
            url : '/admin/ticket-breakdown',
            templateUrl : '/wstr/application/partials/ticket-breakdown',
            controller : 'TicketBreakdownController',
            id : 8,
            skip : false,
            badge : 'mr-2 fa fa-ticket',
            admin : true,
            noadmin : false
        },{
            title : 'Search Tasks and Tours',
            url : '/admin/search-tasks',
            templateUrl : '/wstr/application/partials/search-tasks',
            controller : 'SearchTasksController',
            id : 9,
            skip : false,
            badge : 'mr-2 fa fa-search',
            admin : true,
            noadmin : false
        },{
            title : 'Tools',
            id : 10,
            skip : false,
            badge : 'mr-2 fa fa-gears',
            admin : true,
            noadmin : false,
            subsection : 'tools',
            subSections : [
                {
                    title : 'Email Templates',
                    url : '/admin/email-templates',
                    templateUrl : '/wstr/application/partials/email-templates',
                    controller : 'EmailTemplatesController',
                    id : 1,
                    skip : false,
                    badge : 'mr-2 fa fa-envelope-open',
                    admin : true,
                    noadmin : false
                },
                {
                    title : 'Meta Data',
                    url : '/admin/meta-data',
                    templateUrl : '/wstr/application/partials/meta-data',
                    controller : 'MetaDataController',
                    id : 2,
                    skip : false,
                    badge : 'mr-2 fa fa-database',
                    admin : true,
                    noadmin : true
                }
            ]
        },{
            title : 'My Account',
            url : '/manage-account',
            templateUrl : '/wstr/application/partials/manage-account',
            controller : 'AccountController',
            id : 11,
            skip : false,
            badge : 'mr-2 zmdi zmdi-account',
            admin : false,
            noadmin : false
        }];

        this.isLoading = false;
        this.isLoaded = true;
        this.$routeProvider = null;
        this.setupComplete = false;
    }

    Navigation.prototype.postLoad = function()
    {
        if (this.setupComplete) { return; }

        if ($routeProvider === null)
        {
            setTimeout(this.postLoad, 300);
            return;
        }

        var runConfig = function(nav)
        {
            for (var n in nav)
            {
                if (nav[n].subSections !== undefined)
                {
                    runConfig(nav[n].subSections);
                } else
                {
                    if (nav[n].controller === 'external') { continue; }
                    $routeProvider.when(nav[n].url,
                    {
                        templateUrl : nav[n].templateUrl,
                        controller : nav[n].controller
                    });

                }
            }
        };

        runConfig(this.navigation);

        /**
         * add "hidden" routes here - routes that shouldn't be placed in the main nav
         */
        $routeProvider.when('/new-password',
        {
            templateUrl : '/wstr/application/partials/new-password',
            controller  : 'ManageAccountController'
        });

        $routeProvider.eagerInstantiationEnabled(true);


        // $routeProvider.otherwise({
        //     redirectTo : '/'
        // });

        this.setupComplete = true;
        this.isLoading = false;
        this.isLoaded  = true;

    };

    var staticNavigationInstance = new Navigation();

    angular.module('phillyByFoot')
        .factory('NavigationFactory', ['$route', '$http', '$log', '$q', 'SystemMessagingFactory',
        function($route, $http_, $log_, $q_, SystemMessaging_)
        {
            $http = $http_;
            $log = $log_;
            $q = $q_;
            SystemMessaging = SystemMessaging_;

            staticNavigationInstance.postLoad();
            return staticNavigationInstance;
        }])
        .config(['$routeProvider', function($routeProvider_)
        {
            $routeProvider = $routeProvider_;

        }]);

})(jQuery, angular, document, window);
