(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('GuideAssignmentTicketsCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'GuideAssignmentTicketFactory',
    'AppModelCollectionFactory',
    function ($http, $log, $q, SystemMessaging, GuideAssignmentTicket, AppModelCollection)
    {
        function GuideAssignmentTicketsCollection()
        {
            var self = this;
            this.isLoaded = false;
            this.collection = [];

            this.urlBase = '/wstr/api/guide-assignment-tickets';

            /**
             * getList does not accept the 'POST' method, this is interpreted as create(), so within
             * create() if assignmentIds is set and has a size; we'll forward to getList()
             */
            this.reload = function(guideAssignmentCollection)
            {
                var assignmentIds = guideAssignmentCollection.map(function(guideAssignment)
                {
                    return guideAssignment.id/1;
                });

                if (assignmentIds.length <= 0)
                {
                    assignmentIds.push(0);
                }

                self.isLoaded = false;
                self.loadMethod = 'POST';
                self.postData = {
                    assignmentIds: assignmentIds
                };
                return this.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.hydrateCallback = function(modelData)
            {
                var guideAssignmentTicket = new GuideAssignmentTicket();
                guideAssignmentTicket.hydrate(modelData);

                return guideAssignmentTicket;
            };

        }

        GuideAssignmentTicketsCollection.prototype = AppModelCollection.prototype;

        return new GuideAssignmentTicketsCollection();
    }]);
    
})(jQuery, angular, document, window);
