(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('GuideAssignmentTicketFactory',
    ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
    function($http, $log, $q, $location, SystemMessaging, AppModel)
    {

        function GuideAssignment()
        {
            var self = this;

            this.id = this.assignment_id = this.ticket_id = this.adult = this.child = this.combined = null;

            this.urlBase = '/wstr/api/guide-assignment-tickets';

            this.exports = ['id', 'assignment_id', 'ticket_id', 'adult', 'child', 'combined'];

            this.propertyTypes = {
                number : ['id', 'assignment_id', 'ticket_id', 'adult', 'child', 'combined'],
                bool   : [ ],
                time   : [ ]
            };

            this.getSaveUrl = function()
            {
                return self.id !== undefined && self.id !== null ?
                       self.urlBase + '/' + self.id : self.urlBase;
            };

            this.getSaveMethod = function()
            {
                return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.getDeleteUrl = function()
            {
                return self.urlBase + '/' + self.id;
            };

        }

        GuideAssignment.prototype = AppModel.prototype;


        return GuideAssignment;

    }]);

})(jQuery, angular, document, window);
