(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('GuideAssignmentCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'GuideAssignmentFactory',
    'AppModelCollectionFactory',
    function ($http, $log, $q, SystemMessaging, GuideAssignment, AppModelCollection)
    {
        function GuideAssignmentCollection()
        {
            var self = this;
            this.isLoaded = false;
            this.collection = [];

            this.urlBase = '/wstr/api/guide-assignments';

            /**
             * getList does not accept the 'POST' method, this is interpreted as create(), so within
             * create() if assignmentIds is set and has a size; we'll forward to getList()
             */
            this.reload = function(taskAssignmentCollection)
            {
                var assignmentIds = taskAssignmentCollection.map(function(taskAssignment)
                {
                    return taskAssignment.id/1;
                });

                self.isLoaded = false;
                self.loadMethod = 'POST';
                self.postData = {
                    assignmentIds : assignmentIds
                };

                return this.load();
            };

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.hydrateCallback = function(modelData)
            {
                var guideAssignment = new GuideAssignment();
                guideAssignment.hydrate(modelData);

                return guideAssignment;
            };

            this.getGuideAssignments = function(user)
            {
                return self.collection.filter(function(assignment)
                {
                    return assignment.guide_id/1 === user.id/1;
                });
            };


        }

        GuideAssignmentCollection.prototype = AppModelCollection.prototype;

        return new GuideAssignmentCollection();
    }]);
    
})(jQuery, angular, document, window);