(function ($, angular, document, window) {

    angular.module('phillyByFoot')
    .factory('EmailTemplateCollectionFactory',
    ['$http', '$log', '$q', 'SystemMessagingFactory', 'EmailTemplateFactory', 'AppModelCollectionFactory',
    function ($http, $log, $q, SystemMessaging, EmailTemplate, AppModelCollectionFactory)
    {


        function EmailTemplateCollection()
        {
            var self = this;

            this.urlBase = '/wstr/api/email-template';

            this.collection = [];

            this.getLoadUrl = function()
            {
                return self.urlBase;
            };

            this.hydrateCallback = function(modelData)
            {
                var emailTemplate = new EmailTemplate();
                emailTemplate.hydrate(modelData);

                return emailTemplate;
            };

            this.getTemplate = function(which)
            {
                return (self.collection.filter(function(emailTemplate)
                {
                    return emailTemplate.type === which;
                })).pop();
            };
        }

        EmailTemplateCollection.prototype = AppModelCollectionFactory.prototype;

        return new EmailTemplateCollection();
    }]);
    
})(jQuery, angular, document, window);