(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('EmailTemplateFactory',
        ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
         function($http, $log, $q, $location, SystemMessaging, AppModelFactory)
         {

             function EmailTemplate()
             {
                 var self = this;

                 this.urlBase = '/wstr/api/email-template';
                 this.exports = ['id', 'type', 'content', 'description', 'allowed_variables'];

                 this.id = this.type = this.content = this.description = this.allowed_variables = null;

                 this.modifiedContent = null;

                 this.propertyTypes = {
                     number : ['id'],
                     bool   : [ ],
                     time   : []
                 };

                 this.getMessage = function()
                 {
                     if (self.modifiedContent === null)
                     {
                         self.modifiedContent = self.content;
                     }

                     var returnContent = self.modifiedContent;
                     self.modifiedContent = null;

                     return returnContent;
                 };

                 this.postSaveCallback = function(data)
                 {
                     self.hydrate(data);
                 };

                 this.replaceVariable = function(placeholder, value)
                 {
                     if (self.modifiedContent === null)
                     {
                         self.modifiedContent = self.content;
                     }

                     var searchStr = new RegExp('__' + placeholder + '__', 'g');


                     /**
                      * Can't get the regular expression to treat '[[]]' as literal
                      */
                     while (self.modifiedContent.match(searchStr))
                     {
                         self.modifiedContent = self.modifiedContent.replace(searchStr, value);
                     }

                 };

                 this.getSaveUrl = function ()
                 {
                     return self.id !== undefined && self.id !== null ?
                            self.urlBase + '/' + self.id : self.urlBase;
                 };

                 this.getSaveMethod = function()
                 {
                     return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
                 };

                 this.getLoadUrl = function()
                 {
                     return self.urlBase;
                 };

                 this.getDeleteUrl = function()
                 {
                     return self.urlBase + '/' + self.id;
                 };

             }

             EmailTemplate.prototype = AppModelFactory.prototype;

             return EmailTemplate;

         }]);
})(jQuery, angular, document, window);
