(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('EmailMessageFactory',
        ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
         function($http, $log, $q, $location, SystemMessaging, AppModel)
         {

             function EmailMessage()
             {
                 var self = this;

                 this.messageType = this.messageSubject = this.messageBody =  null;

                 this.messageRecipients = null;
                 this.messageOptions = {};

                 this.exports = ['messageType', 'messageSubject', 'messageBody', 'messageRecipients', 'messageOptions'];

                 this.propertyTypes = {
                     number : [],
                     bool   : [ ],
                     time   : [ ]
                 };

                 this.addRecipient = function()
                 {
                     self.messageRecipients.push({
                         id : null,
                         name : null,
                         email : null,
                         enabled : false
                     });
                 };

                 this.recipientSelected = function()
                 {
                     var selected = false;

                     if (!self.messageRecipients) { return false; }

                     self.messageRecipients.map(function(recipient)
                     {
                         selected = recipient.enabled ? true : selected;
                     });

                     return selected;
                 };

                 this.getSaveUrl = function ()
                 {
                     return '/wstr/api/email-message';
                 };

                 this.getSaveMethod = function()
                 {
                     return 'POST';
                 };

                 this.getLoadUrl = function()
                 {
                     return null;
                 };

                 this.getDeleteUrl = function()
                 {
                     return null;
                 };

                 this.buildCallback = function (property, postData)
                 {
                     if (property === 'messageRecipients' || property === 'messageOptions')
                     {
                         postData[property] = JSON.stringify(postData[property]);
                     }
                 };
             }

             EmailMessage.prototype = AppModel.prototype;


             return EmailMessage;

         }]);

})(jQuery, angular, document, window);
