(function($, angular, document, window)
{
    angular.module('phillyByFoot').factory('AvailabilitiesFactory',
        ['$http', '$log', '$q', '$location', 'SystemMessagingFactory', 'AppModelFactory',
         function($http, $log, $q, $location, SystemMessaging, AppModelFactory)
         {

             function Availabilities()
             {
                 var self = this;

                 this.urlBase = '/wstr/api/availabilities';
                 this.exports = ['id', 'guide_id', 'startdate', 'enddate', 'dayofweek','starttime','endtime','createdate','modifydate'];

                 this.id = this.guide_id = this.startdate = this.enddate = this.dayofweek =
                    this.starttime = this.endtime = this.createdate = this.modifydate = null;

                 this.startTimeObject = null;

                 this.propertyTypes = {
                     number : ['id', 'guide_id', 'dayofweek'],
                     bool   : [ ],
                     time   : ['starttime','endtime']
                 };

                 this.getSaveUrl = function ()
                 {
                     return self.id !== undefined && self.id !== null ?
                            self.urlBase + '/' + self.id : self.urlBase;
                 };

                 this.getSaveMethod = function()
                 {
                     return self.id !== undefined && self.id !== null ? 'PUT' : 'POST';
                 };

                 this.getLoadUrl = function()
                 {
                     return self.urlBase + '/' + self.id;
                 };

                 this.getDeleteUrl = function()
                 {
                     return self.urlBase + '/' + self.id;
                 };

                 this.buildCallback = function(property, model){};


                 this.start_hour = this.start_minute = this.end_hour = this.end_minute;

                 this.hydrateCallback = function(property)
                 {
                     switch (property)
                     {
                         case 'starttime':
                             self.start_hour = self.starttime.getHours();
                             self.start_minute = self.starttime.getMinutes();
                             break;
                         case 'endtime':
                             self.end_hour = self.endtime.getHours();
                             self.end_minute = self.endtime.getMinutes();
                             break;
                     }
                 };

                 this.updateAvailabilityTime = function()
                 {

                     self.startTimeObject = new Date(self.startdate + " 00:00:00").getTime();

                     if (self.starttime === null)
                     {
                         self.starttime = new Date(self.startdate + " 00:00:00");
                         self.starttime.setHours(6);
                         self.starttime.setMinutes(0);
                         self.starttime.setSeconds(0);
                         self.starttime.setMilliseconds(0);
                     }

                     if (self.endtime === null)
                     {
                         self.endtime = new Date(self.startdate + " 00:00:00");
                         self.endtime.setHours(6);
                         self.endtime.setMinutes(0);
                         self.endtime.setSeconds(0);
                         self.endtime.setMilliseconds(0);
                     }

                     self.starttime.setHours(self.start_hour/1);
                     self.starttime.setMinutes(self.start_minute/1);
                     self.endtime.setHours(self.end_hour/1);
                     self.endtime.setMinutes(self.end_minute/1);

                 };

             }

             Availabilities.prototype = AppModelFactory.prototype;

             return Availabilities;

         }]);
})(jQuery, angular, document, window);
