/**
 * This directive provideds for adding input elements to a matrix of keyboard navigable objects
 * allowing users to use their keyboard to navigate between records
 */
(function($, angular, document, window)
{
    var navigationMatrix = [];

    function getCaretPos(element)
    {
        /* < IE 9 support */
        if (document.selection)
        {
            element.focus();
            var oSel = document.selection.createRange ();
            oSel.moveStart ('character', -element.value.length);
            return oSel.text.length;
        }
        /* everyone else in the universe */
        if (element.selectionStart || element.selectionStart == '0')
        {
            return element.selectionStart;
        }
    }

    function getSelectedText(element)
    {
        /* < IE 9 support */
        if (document.selection)
        {
            element.focus();
            var s = document.selection.createRange();
            return s.text;
        }

        /* everyone else in the universe */
        return window.getSelection().toString();
    }

    angular.module('phillyByFoot')
    .directive('inputNavigation', ['$window', 'MonthsFactory', function($window, months)
     {
        return {
            restrict : 'A',
            link : function(scope, element, attrs, ctrl)
            {
                var r = attrs.navElementRow;
                var c = attrs.navElementCol;

                if (months.indexOf(r) !== -1) { r = months.indexOf(r); }
                if (months.indexOf(c) !== -1) { c = months.indexOf(c); }

                if (typeof navigationMatrix[r] == 'undefined')
                {
                    navigationMatrix[r] = [];
                }

                /* let's fudge these into numbers */
                r *= 1;
                c *= 1;

                navigationMatrix[r][c] = element;

                element.bind('keydown', function(e)
                {
                    var r = attrs.navElementRow;
                    var c = attrs.navElementCol;

                    if (months.indexOf(r) !== -1) { r = months.indexOf(r); }
                    if (months.indexOf(c) !== -1) { c = months.indexOf(c); }

                    /* let's fudge these into numbers */
                    r *= 1;
                    c *= 1;

                    /* get the position of the caret and the input length for up/down/left/right later */
                    var cPos = getCaretPos(this);
                    var len = this.value.length;
                    var selectedText = getSelectedText(this);

                    switch (e.keyCode)
                    {
                        case 40: /* down arrow */
                        case 13: /* enter key */
                            /* hitting enter indicates done editing, move down as in spreadsheet layouts, this is the
                             * default expected (learned) behavior of users working with spreadsheets
                             * this is also the expected result when a user hits the down arrow */

                            /* try to find the next "downmost" unhidden input */
                            do {
                                r += 1;
                                if (r >= navigationMatrix.length) { r = 0; }
                                if (navigationMatrix[r][c].hasClass('ng-hide')) { continue; }
                                navigationMatrix[r][c].focus();
                                break;
                            } while (true);
                            scope.$apply();
                            break;

                        case 37: /* left arrow */
                            /* position will always be 0 on first focus, but there will also be a selection
                             * move one left to remove the selection, move left again to move to the next
                             * leftmost input */
                            if (cPos === 0 && ((selectedText != this.value) || this.value === ""))
                            {
                                /* try to find the next leftmost unhidden input */
                                do {
                                    c -= 1;
                                    if (c < 0) { c = navigationMatrix[r].length - 1; }
                                    if (navigationMatrix[r][c].hasClass('ng-hide')) { continue; }
                                    navigationMatrix[r][c].focus();
                                    break;
                                } while(true);
                                scope.$apply();
                            }
                            break;

                        case 38: /* up arrow */
                            /*- special case, default is to move up no matter what - no moving to start of input
                             * users will expect this behavior, normally up arrows are not used to move to the start of the input
                             */

                            /* try to find the next "upmost" unhidden element */
                            do {
                                r -= 1;
                                if (r < 0) { r = navigationMatrix.length - 1; }
                                if (navigationMatrix[r][c].hasClass('ng-hide')) { continue; }
                                navigationMatrix[r][c].focus();
                                break;
                            } while(true);
                            scope.$apply();
                            break;

                        case 39: /* right arrow */
                            /* move right, to end of input - removes selection, still allows editing - will never be 0 on initial focus
                             * because initial focus causes selection, moving right removes the selection as the user would expect and
                             * allow editing from the end of input */
                            if (cPos == len)
                            {
                                /* try to find the next rightmost unhidden input */
                                do {
                                    c += 1;
                                    if (c >= navigationMatrix[r].length) { c = 0; }
                                    if (navigationMatrix[r][c].hasClass('ng-hide')) { continue; }
                                    navigationMatrix[r][c].focus();
                                    break;
                                } while (true);
                                scope.$apply();
                            }
                            break;
                    }
                });
            }
        };
     }]);

})(jQuery, angular, document, window);
