(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    .controller('TourEmailController', ['$q','$filter','$scope', '$http', '$window', '$location', 'UsersCollectionFactory',
    'GuideAssignmentCollectionFactory', 'EmailMessageFactory', 'EmailTemplateCollectionFactory', 'IntraControllerActionHandlerFactory',
    function($q, $filter, $scope, $http, $window, $location, UsersCollection, GuideAssignmentCollection, EmailMessage,
             EmailTemplateCollection, IntraControllerActionHandler)
    {
        window.scrollTo(0,0);

        if (!IntraControllerActionHandler.model)
        {
            $scope.activeTaskAssignment = null;
            $location.path(IntraControllerActionHandler.returnPath ? IntraControllerActionHandler.returnPath : '/admin/calendar');
            return;
        }

        $scope.usersCollection = UsersCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.emailTemplateCollection = EmailTemplateCollection;
        $scope.emailMessage = null;
        $scope.returnPath = null;

        $scope.editType = null;
        $scope.activeDay = null;
        $scope.activeTaskAssignment = null;
        $scope.changesActive = false;

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };


        $scope.getGuideAssignments = function(taskAssignment)
        {
            if (!taskAssignment) { return []; }
            return $scope.guideAssignmentCollection.collection.filter(function(guideAssignment)
            {
                return guideAssignment.taskassignment_id/1 === taskAssignment.id/1;
            });
        };

        $scope.getLeadGuide = function(taskAssignment)
        {
            if (!taskAssignment) { return null; }
            /**
             * If the lead guide is giving the tour, just return that
             */
            if (taskAssignment.guide_id/1 > 0 && taskAssignment.leadguidegivingtour)
            {
                return $scope.getGuide(taskAssignment.guide_id);
            }

            /**
             * Get the first assigned guide and return that
             */
            var guideAssignment = ($scope.getGuideAssignments(taskAssignment).filter(function(guideAssignment)
            {
                return guideAssignment.status/1 > 0;
            })).pop();

            return $scope.getGuide(guideAssignment.guide_id);

        };

        $scope.getGuide = function(userId)
        {
            if (!userId) { return null; }

            return ($scope.usersCollection.users.filter(function(user)
            {
                return user.id/1 === userId/1;
            })).pop();
        };

        $scope.sendConfirmationEmail = function(taskAssignment)
        {
            $scope.editType = 'confirmationEmail';

            $scope.emailMessage.messageSubject = taskAssignment.getConfirmationMessageSubject();
            var emailTemplate = $scope.emailTemplateCollection.getTemplate(taskAssignment.getConfirmationTemplateKey());

            var leadGuide = $scope.getLeadGuide(taskAssignment);

            emailTemplate.replaceVariable("GUIDE_NAME", leadGuide.firstName());
            emailTemplate.replaceVariable("GUIDE_CELL", leadGuide.cellphone);
            emailTemplate.replaceVariable("ARRIVE_TIME", $filter('date')(taskAssignment.starttime.addMinutes(-15), 'h:mm a'));
            emailTemplate.replaceVariable("TOUR_DATE", $filter('date')(taskAssignment.starttime, 'MMMM d, yyyy'));
            emailTemplate.replaceVariable("TOUR_TIME", $filter('date')(taskAssignment.starttime, 'h:mm a'));
            emailTemplate.replaceVariable("NUM_GROUPS", taskAssignment.numguidesrequired);
            
            $scope.emailMessage.messageType = 'SimpleEmailMessage';
            $scope.emailMessage.messageBody = emailTemplate.getMessage();

            $scope.emailMessage.messageRecipients = [{
                id : null,
                name : taskAssignment.tourcontactname,
                email : taskAssignment.tourcontactemail,
                enabled : true
            }];
        };

        $scope.sendThankYouEmail = function(taskAssignment)
        {
            $scope.editType = 'thanksEmail';

            var emailTemplate = null;
            $scope.emailMessage.messageType = 'SimpleEmailMessage';

            $scope.emailMessage.messageSubject = taskAssignment.getThankYouMessageSubject();

            emailTemplate = $scope.emailTemplateCollection.getTemplate(taskAssignment.getThankYouTemplateKey());

            $scope.emailMessage.messageBody = emailTemplate.getMessage();

            $scope.emailMessage.messageRecipients = [{
                id : null,
                name : taskAssignment.tourcontactname,
                email : taskAssignment.tourcontactemail,
                enabled : true
            }];
        };

        $scope.sendEmailMessage = function()
        {
            var model = IntraControllerActionHandler.model;

            var thankyouemailto = [];

            $scope.emailMessage.messageRecipients.forEach(function(recipient)
            {
                if (recipient.enabled)
                {
                    thankyouemailto.push(recipient.email);
                }
                return recipient.enabled;
            });

            thankyouemailto = thankyouemailto.join(', ');


            $scope.emailMessage.save().then(function(success)
            {
                if (success)
                {
                    if (model.confirmationemaildate)
                    {
                        model.confirmationemaildate = $filter('date')(model.confirmationemaildate, 'yyyy-MM-dd');
                    }
                    if (model.thankyouemaildate)
                    {
                        model.thankyouemaildate = $filter('date')(model.thankyouemaildate, 'yyyy-MM-dd');
                    }
                    if (IntraControllerActionHandler.action === 'send-confirmation-email')
                    {
                        model.confirmationemaildate = $filter('date')(new Date(), 'yyyy-MM-dd');
                    } else if (IntraControllerActionHandler.action === 'send-thank-you-email')
                    {
                        model.thankyouemaildate = $filter('date')(new Date(), 'yyyy-MM-dd');
                        model.thankyouemailto = thankyouemailto;
                    }
                    model.save().then(function()
                    {
                        $scope.isEditing = false;
                        $scope.editType = null;
                        $scope.changesActive = false;
                        $scope.returnToPreviousController();
                    });
                }
            });
        };

        $scope.returnToPreviousController = function()
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }

            IntraControllerActionHandler.model = IntraControllerActionHandler.priorModel;
            IntraControllerActionHandler.action = IntraControllerActionHandler.priorAction;
            IntraControllerActionHandler.date = IntraControllerActionHandler.priorDate;
            IntraControllerActionHandler.returnPath = IntraControllerActionHandler.priorReturnPath;
            IntraControllerActionHandler.priorAction = null;
            IntraControllerActionHandler.priorDate = null;
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorReturnPath = null;
            IntraControllerActionHandler.stopEvents = false;
            $scope.changesActive = false;

            $location.path($scope.returnPath);

        };

        $scope.returnToCalendar = function()
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }

            IntraControllerActionHandler.model = IntraControllerActionHandler.priorModel;
            IntraControllerActionHandler.action = IntraControllerActionHandler.priorAction;
            IntraControllerActionHandler.date = IntraControllerActionHandler.priorDate;
            IntraControllerActionHandler.returnPath = IntraControllerActionHandler.priorReturnPath;
            IntraControllerActionHandler.priorAction = null;
            IntraControllerActionHandler.priorDate = null;
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorReturnPath = null;
            IntraControllerActionHandler.stopEvents = false;
            $scope.changesActive = false;

            $location.path('/admin/calendar');

        };

        $scope.openDayDetails = function()
        {
            if ($scope.changesActive && !confirm("You have unsaved changes. Are you sure you wish to leave?"))
            {
                return;
            }

            IntraControllerActionHandler.model = IntraControllerActionHandler.priorModel;
            IntraControllerActionHandler.action = IntraControllerActionHandler.priorAction;
            IntraControllerActionHandler.date = IntraControllerActionHandler.priorDate;
            IntraControllerActionHandler.returnPath = IntraControllerActionHandler.priorReturnPath;
            IntraControllerActionHandler.priorAction = null;
            IntraControllerActionHandler.priorDate = null;
            IntraControllerActionHandler.priorModel = null;
            IntraControllerActionHandler.priorReturnPath = null;
            IntraControllerActionHandler.stopEvents = false;
            $scope.changesActive = false;

            $location.path('/admin/day-details');

        };

        var promises = [];

        promises.push($scope.usersCollection.load());
        promises.push($scope.emailTemplateCollection.load());

        $q.all(promises).then(function()
        {
            IntraControllerActionHandler.stopEvents = true;
            $scope.activeTaskAssignment = IntraControllerActionHandler.model;
            $scope.activeDay = IntraControllerActionHandler.date;
            $scope.returnPath = IntraControllerActionHandler.returnPath;

            $scope.emailMessage = new EmailMessage();

            if (IntraControllerActionHandler.action === 'send-thank-you-email')
            {
                $scope.sendThankYouEmail($scope.activeTaskAssignment);
            } else if (IntraControllerActionHandler.action === 'send-confirmation-email')
            {
                $scope.sendConfirmationEmail($scope.activeTaskAssignment);
            } else
            {
                alert('Unknown Action Specified: Returning');
                $scope.returnToPreviousController();
            }

            $scope.$watchCollection('emailMessage', function(newValue, oldValue)
            {
                if (newValue && oldValue)
                {
                    Object.keys(newValue).forEach(function (property)
                    {
                        if (newValue.hasOwnProperty(property) && typeof newValue[property] !== 'function')
                        {
                            if (newValue[property] !== oldValue[property])
                            {
                                $scope.changesActive = true;
                            }
                        }
                    });
                }
            });
        });
    }]);

})($, angular, document, window);
