(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('MetaDataController', ['$q', '$scope', '$http', '$window', '$location', 'StaticUserFactory',
    'TaskTypesCollectionFactory','TaskTypeFactory','TourTypesCollectionFactory','TourTypeFactory',
    'OrganizationsCollectionFactory','OrganizationFactory', 'TicketTypeCollectionFactory',
    'TicketTypeFactory',
    function($q, $scope, $http, $window, $location, StaticUser, TaskTypesCollection, TaskType,
             TourTypesCollection, TourType, OrganizationsCollection, Organization,
            TicketTypeCollection, TicketType)
    {
        $scope.staticUser = StaticUser;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.ticketTypeCollection = TicketTypeCollection;
        $scope.editingTaskType = null;
        $scope.editingTourType = null;
        $scope.editingOrganization = null;
        $scope.editingTicketType = null;

        $scope.toggleOrganizations = function (ticketType)
        {
            if (!ticketType.spirits)
            {
                ticketType.constitutional = true;
                ticketType.organization_id = 1;
            }
            if (!ticketType.constitutional)
            {
                ticketType.spirits = true;
                ticketType.organization_id = 2;
            }
            if (ticketType.constitutional && ticketType.spirits)
            {
                ticketType.organization_id = null;
            }
            ticketType.save();
        };

        $scope.autoSaveTaskType = function(taskType)
        {
            $scope.editingTaskType = null;
            taskType.save();
        };

        $scope.autoSaveTourType = function(tourType)
        {
            $scope.editingTourType = null;
            tourType.save();
        };

        $scope.autoSaveTicketType = function(ticketType)
        {
            $scope.editingTicketType = null;
            ticketType.save();
        };

        $scope.autoSaveOrganization = function(organization)
        {
            $scope.editingOrganization = null;
            organization.save();
        };

        $scope.deleteTaskType = function(taskType)
        {
            if (confirm("Warning: Removing this task type will remove ALL data dependent on this task type.  "+
                        "Are you sure you wish to continue?"))
            {
                $scope.editingTaskType = null;
                $scope.taskTypesCollection.deleteTaskType(taskType);
            }
        };

        $scope.deleteTourType = function(tourType)
        {
            if (confirm("Warning: Removing this tour type will remove ALL data dependent on this tour type.  "+
                        "Are you sure you wish to continue?"))
            {
                $scope.editingTourType = null;
                $scope.tourTypesCollection.deleteTourType(tourType);
            }
        };

        $scope.deleteTicketType = function(ticketType)
        {
            if (confirm("Warning: Removing this ticket type will remove ALL data dependent on this ticket type.  "+
                        "Are you sure you wish to continue?"))
            {
                $scope.editingTicketType= null;
                $scope.ticketTypeCollection.deleteEntry(ticketType);
            }
        };


        $scope.deleteOrganization = function(organization)
        {
            if (confirm("Warning: Removing this organization will remove ALL data dependent on this organization.  "+
                        "Are you sure you wish to continue?"))
            {
                $scope.editingOrganization = null;
                $scope.organizationsCollection.deleteOrganization(organization);
            }
        };

        $scope.editTaskType = function(taskType)
        {
            $scope.editingTaskType = taskType;
            /** let's hope 60ms is enough time for everything to update so the input field is visible and you can call .focus() */
            setTimeout(function(){
                document.getElementById('task-type-' + taskType.id).focus();
            }, 60);
        };

        $scope.editTourType = function(tourType)
        {
            $scope.editingTourType = tourType;
            /** let's hope 60ms is enough time for everything to update so the input field is visible and you can call .focus() */
            setTimeout(function(){
                document.getElementById('tour-type-' + tourType.id).focus();
            }, 60);
        };

        $scope.editTicketType = function(ticketType)
        {
            $scope.editingTicketType = ticketType;
        };

        $scope.editOrganization = function(organization)
        {
            $scope.editingOrganization = organization;
            /** let's hope 60ms is enough time for everything to update so the input field is visible and you can call .focus() */
            setTimeout(function(){
                document.getElementById('organization-' + organization.id).focus();
            }, 60);
        };

        $scope.addNewTaskType = function()
        {
            var $task = new TaskType();
            $task.save().then(function()
            {
                $scope.editTaskType($task);
            });
            $scope.taskTypesCollection.taskTypes.push($task);

        };

        $scope.addNewTicketType = function()
        {
            var ticketType = new TicketType();
            ticketType.save().then(function ()
            {
                $scope.editingTicketType(ticketType);
            });
            $scope.ticketTypeCollection.collection.push(ticketType);
        };

        $scope.addNewTourType = function()
        {
            var tour = new TourType();
            tour.save().then(function()
            {
                $scope.editTourType(tour);
            });
            $scope.tourTypesCollection.tourTypes.push(tour);
        };

        $scope.addNewOrganization = function()
        {
            var organization = new Organization();
            organization.save().then(function()
            {
                $scope.editOrganization(organization);
            });
            $scope.organizationsCollection.organizations.push(organization);
        };

        var promises = [];

        promises.push($scope.staticUser.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.ticketTypeCollection.load());

        $q.all(promises).then(function()
        {
        });
    }]);

})($, angular, document, window);
