(function($, angular, document, window)
{

    angular.module('phillyByFoot')
    /* controller for app */
    .controller('DayTypesController', ['$q', '$scope', '$http', '$window', '$location', 'StaticUserFactory',
    'DayTypesCollectionFactory', 'DayTypeFactory', 'ShiftsCollectionFactory', 'ShiftFactory',
    'TaskCollectionFactory', 'TaskFactory', 'TaskTypesCollectionFactory', 'HourSelectFactory', 'MinuteSelectFactory',
    function($q, $scope, $http, $window, $location, StaticUser, DayTypesCollection, DayType, ShiftsCollection, Shift,
        TaskCollection, Task, TaskTypesCollection, HourSelectFactory, MinuteSelectFactory)
    {
        $scope.staticUser = StaticUser;
        $scope.dayTypesCollection = DayTypesCollection;
        $scope.shiftsCollection = ShiftsCollection;
        $scope.taskCollection = TaskCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.sortType = 'fullName';
        $scope.editingDayType = null;
        $scope.openShiftsGroup = null;
        $scope.editingShift = null;
        $scope.hourOptions = HourSelectFactory;
        $scope.minuteOptions = MinuteSelectFactory;


        $scope.toggleShiftGroup = function(dayType)
        {
            if ($scope.openShiftsGroup !== null && $scope.openShiftsGroup.id/1 === dayType.id/1)
            {
                $scope.openShiftsGroup = null;
            } else
            {
                $scope.openShiftsGroup = dayType;
            }
        };

        $scope.setSort = function(which)
        {
            switch (which)
            {
                case 'name' :
                    if ($scope.sortType === 'fullName') { $scope.sortType = '-fullName'; }
                    else                            { $scope.sortType = 'fullName'; }
                    break;
                case 'status':
                    if ($scope.sortType === 'status') { $scope.sortType = '-status'; }
                    else                              { $scope.sortType = 'status'; }
                    break;
            }
        };

        $scope.editDayType = function(dayType)
        {
            $scope.editingDayType = dayType;
            setTimeout(function(){
                document.getElementById('day-type-' + dayType.id).focus();
            }, 60);
        };

        $scope.autoSaveDayType = function(dayType)
        {
            $scope.editingDayType = null;
            dayType.save();
        };

        $scope.deleteDayType = function(dayType)
        {
            if (confirm("Warning: Removing this day type will remove ALL data dependent on this day type.  "+
                        "Are you sure you wish to continue?"))
            {
                $scope.editingDayType = null;
                $scope.dayTypesCollection.deleteDayType(dayType);
            }
        };

        $scope.addNewDayType = function()
        {
            var dayType = new DayType();
            dayType.save().then(function()
            {
                $scope.editDayType(dayType);
            });
            $scope.dayTypesCollection.dayTypes.push(dayType);
        };

        $scope.setEditingShift = function(shift)
        {
            if ($scope.editingShift === shift)
            {
                $scope.editingShift = null;
            } else
            {
                $scope.editingShift = shift;
            }
        };

        $scope.saveShift = function(shift)
        {
            $scope.editingShift = null;
            shift.save();
        };

        $scope.deleteShift = function(shift)
        {
            if (confirm("Are you sure you wish to delete this shift?"))
            {
                $scope.editingShift = null;
                $scope.shiftsCollection.deleteShift(shift);
            }
        };

        $scope.addShift = function(dayType)
        {
            var shift = new Shift();
            shift.daytype_id = dayType.id;
            shift.save().then(function()
            {
                $scope.setEditingShift(shift);
            });
            $scope.shiftsCollection.shifts.push(shift);
        };

        $scope.addTask = function(shift)
        {
            var task = new Task();
            task.shift_id = shift.id;
            task.starttime = new Date();
            task.endtime = new Date();
            task.starttime.setMinutes(0);
            task.starttime.setSeconds(0);
            task.starttime.setMilliseconds(0);
            task.endtime.setMinutes(0);
            task.endtime.setSeconds(0);
            task.endtime.setMilliseconds(0);
            task.tasktype = $scope.taskTypesCollection.taskTypes[0].id;
            task.save();
            $scope.taskCollection.tasks.push(task);
        };

        $scope.deleteTask = function(task)
        {
            if (confirm("Are you sure you wish to delete this task?"))
            {
                $scope.taskCollection.deleteTask(task);
            }
        };

        $scope.getShiftStartTime = function(shift)
        {
            var list = $scope.taskCollection.tasks.filter(function(obj)
            {
                return obj.shift_id/1 === shift.id/1;
            });

            var min = null;

            for (var i=0; i<list.length; i++)
            {
                if (list[i].status/1 !== 1) { continue; }
                if (min === null || list[i].starttime < min) { min = list[i].starttime; }
            }

            return min;
        };

        $scope.getShiftEndTime = function(shift)
        {
            var list = $scope.taskCollection.tasks.filter(function(obj)
            {
                return obj.shift_id/1 === shift.id/1;
            });

            var max = null;

            for (var i=0; i<list.length; i++)
            {
                if (list[i].status/1 !== 1) { continue; }
                if (max === null || list[i].endtime > max) { max = list[i].endtime; }
            }

            return max;
        };

        var promises = [];

        promises.push($scope.staticUser.load());
        promises.push($scope.dayTypesCollection.load());
        promises.push($scope.shiftsCollection.load());
        promises.push($scope.taskCollection.load());
        promises.push($scope.taskTypesCollection.load());

        $q.all(promises).then(function()
        {
        });
    }]);

})($, angular, document, window);
