(function($, angular, document, window)
{


    angular.module('phillyByFoot')
    /* controller for app */
    .controller('AdminTimeSheetsController', ['$q', '$sce','$scope', '$filter', '$http', '$window', '$location',
    'UsersCollectionFactory', 'OrganizationsCollectionFactory', 'TaskAssignmentCollectionFactory',
    'GuideTimeSheetCollectionFactory', 'GuideAssignmentCollectionFactory', 'TaskTypesCollectionFactory',
    'TourTypesCollectionFactory', 'HourSelectFactory', 'MinuteSelectFactory', 'ConditionsSelectFactory',
    'PrecipitationSelectFactory','TemperatureSelectFactory', 'PayPeriodFactory',
    function($q, $sce, $scope, $filter, $http, $window, $location, UsersCollection, OrganizationsCollection,
             TaskAssignmentCollection, GuideTimeSheetCollection, GuideAssignmentCollection,
             TaskTypesCollection, TourTypesCollection, HourSelect, MinuteSelect, ConditionsSelect,
             PrecipitationSelect, TemperatureSelect, PayPeriod)
    {
        $scope.usersCollection = UsersCollection;
        $scope.taskTypesCollection = TaskTypesCollection;
        $scope.tourTypesCollection = TourTypesCollection;
        $scope.organizationsCollection = OrganizationsCollection;
        $scope.taskAssignmentCollection = TaskAssignmentCollection;
        $scope.guideTimeSheetCollection = GuideTimeSheetCollection;
        $scope.guideAssignmentCollection = GuideAssignmentCollection;
        $scope.hourOptions = HourSelect;
        $scope.minuteOptions = MinuteSelect;
        $scope.conditionsSelect = ConditionsSelect;
        $scope.precipitationSelect = PrecipitationSelect;
        $scope.temperatureSelect = TemperatureSelect;
        $scope.payPeriod = PayPeriod;

        $scope.activeDetails = null;
        $scope.activeUser = null;
        $scope.editingSheet = null;

        $scope.orgEnabled = {
            constitutional : true,
            spirits : true
        };

        $scope.tinymceOptions = {
            plugins: 'lists',
            branding : false,
            menubar : 'edit format',
            browser_spellcheck : true,
            content_css : '/css/style.css'
        };

        $scope.updatePayPeriod = function(which, startEnd)
        {
            $scope.payPeriod.updatePayPeriod(which, startEnd, function()
            {

                var start = new Date($scope.payPeriod.datePicker.start);
                var end   = new Date($scope.payPeriod.datePicker.end);

                var promises = [];

                promises.push($scope.taskAssignmentCollection.reload(start, end));
                promises.push($scope.guideTimeSheetCollection.reload(start, end));

                $q.all(promises).then(function()
                {
                    $scope.guideAssignmentCollection.reload($scope.taskAssignmentCollection.collection);

                    $scope.payPeriod.activeDays.map(function(day)
                    {
                        day.guideTimeSheets = $scope.getTimeSheets(day.day);
                        day.taskAssignments = $scope.getTaskAssignments(day.day);
                    });
                });
            });
        };

        $scope.editSheet = function(timesheet)
        {
            if ($scope.editingSheet === null)
            {
                $scope.editingSheet = timesheet;
            } else
            {
                $scope.editingSheet = null;
            }
        };

        $scope.closeEditor = function()
        {
            $scope.activeDetails = $scope.activeUser = $scope.editingSheet = null;
        };

        $scope.saveSheet = function()
        {
            $scope.editingSheet.save();
            $scope.editingSheet = null;
        };

        $scope.getTaskType = function(id)
        {
            return ($scope.taskTypesCollection.taskTypes.filter(function(taskType)
            {
                return taskType.id/1 === id/1;
            })).pop();
        };

        $scope.getTourType = function(id)
        {
            return ($scope.tourTypesCollection.tourTypes.filter(function(tourType)
            {
                return tourType.id/1 === id/1;
            })).pop();
        };

        $scope.getFilteredUsers = function()
        {
            return $scope.usersCollection.users.filter(function(user)
            {
                if (!user.status) { return false; }
                if (user.organization_constitutional && $scope.orgEnabled.constitutional) { return true; }
                if (user.organization_spirits && $scope.orgEnabled.spirits) { return true; }
            });
        };

        $scope.checkOrganizations = function(which)
        {
            switch (which)
            {
                case 'constitutional':
                    if (!$scope.orgEnabled.constitutional && !$scope.orgEnabled.spirits)
                    {
                        $scope.orgEnabled.spirits = true;
                    }
                    break;
                case 'spirits':
                    if (!$scope.orgEnabled.constitutional && !$scope.orgEnabled.spirits)
                    {
                        $scope.orgEnabled.constitutional = true;
                    }
                    break;
            }
        };


        var logged = false;
        $scope.getTaskAssignmentsForUser = function(dayDetails, user)
        {
            if (dayDetails && user && dayDetails.taskAssignments)
            {
                var guideAssignments = $scope.guideAssignmentCollection.getGuideAssignments(user);

                var taskAssignmentIds = guideAssignments.filter(function(assignment)
                {
                    return assignment.status;
                }).map(function (assignment)
                {
                    return assignment.taskassignment_id / 1;
                });


                return dayDetails.taskAssignments.filter(function (taskAssignment)
                {
                    if (!$scope.orgEnabled.constitutional && taskAssignment.organization_id/1 === 1) { return false; }
                    if (!$scope.orgEnabled.spirits && taskAssignment.organization_id/1 === 2) { return  false; }

                    return taskAssignmentIds.indexOf(taskAssignment.id / 1) >= 0;
                });
            }
        };

        $scope.isMissingTimeSheet = function(dayDetails, user)
        {
            var currentDay = new Date();
            currentDay.setHours(0);
            currentDay.setMinutes(0);
            currentDay.setSeconds(0);
            currentDay.setMilliseconds(0);

            var taskAssignments = $scope.getTaskAssignmentsForUser(dayDetails, user);
            var userTimeSheets = $scope.getTimeSheetsForUser(dayDetails, user);

            return (taskAssignments && userTimeSheets && taskAssignments.length > 0 && userTimeSheets.length <= 0) &&
                dayDetails.day <= currentDay;
        };

        $scope.getTimeSheetsForUser = function(dayDetails, user)
        {
            if (dayDetails && user && dayDetails.guideTimeSheets)
            {
                return dayDetails.guideTimeSheets.filter(function (sheet)
                {
                    if (!$scope.orgEnabled.constitutional && sheet.organization_id/1 === 1) { return false; }
                    if (!$scope.orgEnabled.spirits && sheet.organization_id/1 === 2) { return  false; }
                    return sheet.guide_id / 1 === user.id / 1;
                });
            }
        };

        $scope.getScheduledHours = function(dayDetails, user)
        {
            var totalScheduledSeconds = 0;
            var taskAssignments = $scope.getTaskAssignmentsForUser(dayDetails, user);
            taskAssignments.map(function(assignment)
            {
                totalScheduledSeconds += assignment.getSecondsScheduled();
            });

            var hours = Math.trunc(totalScheduledSeconds/60/60);
            var minutes = (totalScheduledSeconds/60) % 60;

            return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
        };

        var timeDetails = {
            realTime    : null,
            roundedTime : null,
            excessTime  : null,
            totalTasks  : null,
            secondsWorked : null,
            notes       : '',
            day         : null,
            user_id     : null
        };

        $scope.stripHtml = function(html)
        {
            var doc = new DOMParser().parseFromString(html, 'text/html');
            return doc.body ? doc.body.textContent : '';
        };

        $scope.getTimeWorked = function(dayDetails, user)
        {
            var sheets = $scope.getTimeSheetsForUser(dayDetails, user);
            var taskAssignments = $scope.getTaskAssignmentsForUser(dayDetails, user);

            var totalScheduledSeconds = 0;
            var totalWorkedSeconds = 0;

            if (timeDetails.day !== null && timeDetails.day === dayDetails.day &&
                timeDetails.user_id !== null && timeDetails.user_id === user.id)
            {
                return timeDetails;
            } else
            {
                timeDetails = {
                    realTime    : null,
                    roundedTime : null,
                    excessTime  : null,
                    totalTasks  : null,
                    secondsWorked : null,
                    notes       : '',
                    day         : null,
                    user_id     : null
                };
            }

            var hours, minutes, seconds = 0, notes = '';

            if (taskAssignments && sheets && sheets.length > 0)
            {

                taskAssignments.map(function(assignment)
                {
                    totalScheduledSeconds += assignment.getSecondsScheduled();
                });

                sheets.map(function(sheet)
                {
                    totalWorkedSeconds += sheet.getSecondsWorked();
                });

                var excessSeconds = totalWorkedSeconds - totalScheduledSeconds;

                hours = Math.trunc(excessSeconds/60/60);
                minutes = (excessSeconds/60) % 60;

                // timeDetails.excessTime = hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
                timeDetails.excessTime = (excessSeconds/60/60).toFixed(2);
                hours = minutes = 0;

                timeDetails.totalTasks = taskAssignments.length;

                for (var i=0; i<sheets.length; i++)
                {
                    notes += sheets[i].notes + "\n";
                    hours += sheets[i].getHoursWorked();
                    minutes += sheets[i].getMinutesWorked();
                    seconds += sheets[i].getSecondsWorked();
                }

                timeDetails.notes = "Notes: " + notes;
                if (excessSeconds)
                {
                    timeDetails.notes += "  -- Overtime by " + timeDetails.excessTime;
                }


                // timeDetails.realTime = hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
                timeDetails.realTime = (seconds/60/60).toFixed(2);
                timeDetails.secondsWorked = seconds;

                $sce.trustAsHtml(timeDetails.notes);
                /**
                 * Minimum time is 2 hours, but only if 1 tour and tour lasted < 2 hours
                 */
                if (hours < 2)
                {
                    if (taskAssignments.length === 1 && taskAssignments[0].tasktype === 1)
                    {
                        timeDetails.roundedTime = '2.00';
                        timeDetails.secondsWorked = 120 * 60;
                    }
                }

                return timeDetails;
            }

            return null;
        };

        $scope.getTotalHours = function(seconds)
        {
            var totalWorkedSeconds = 0;

            var users = $scope.getFilteredUsers();

            $scope.payPeriod.activeDays.map(function(dayDetails)
            {
                users.map(function(user)
                {
                    var timeWorked = $scope.getTimeWorked(dayDetails, user);
                    totalWorkedSeconds += timeWorked ? timeWorked.secondsWorked : 0;
                });
            });

            if (seconds) { return totalWorkedSeconds; }

            var hours = Math.trunc(totalWorkedSeconds/60/60);
            var minutes = (totalWorkedSeconds/60) % 60;

            if (totalWorkedSeconds)
            {
                return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
            }

        };

        $scope.getPayroll = function(user)
        {
            var totalHours = $scope.getTotalUserHours(user, false, true);

            if (totalHours)
            {
                return (user.rate * totalHours).toFixed(2)/1;
            }
        };

        $scope.getTotalPayroll = function()
        {
            var totalPayroll = 0;
            var users = $scope.getFilteredUsers();

            users.map(function(user)
            {
                var payroll = $scope.getPayroll(user);
                totalPayroll += payroll ? payroll : 0;
            });

            if (totalPayroll)
            {
                return totalPayroll;
            }
        };

        $scope.getTotalUserHours = function(user, seconds, fractional)
        {
            var totalWorkedSeconds = 0;

            $scope.payPeriod.activeDays.map(function(dayDetails)
            {
                var timeWorked = $scope.getTimeWorked(dayDetails, user);
                totalWorkedSeconds += timeWorked ? timeWorked.secondsWorked : 0;
            });

            // var hours = Math.trunc(totalWorkedSeconds/60/60);
            // var minutes = (totalWorkedSeconds/60) % 60;

            if (totalWorkedSeconds)
            {

                if (seconds) { return totalWorkedSeconds; }
                // if (fractional) { return (totalWorkedSeconds/60/60).toFixed(2)/1; }
                return (totalWorkedSeconds/60/60).toFixed(2)/1;


                // return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
            }

        };

        $scope.getDailyTotalHours = function(dayDetails, seconds)
        {
            var totalWorkedSeconds = 0;

            var users = $scope.getFilteredUsers();

            users.map(function(user)
            {
                var timeWorked = $scope.getTimeWorked(dayDetails, user);
                totalWorkedSeconds += timeWorked ? timeWorked.secondsWorked : 0;
            });

            if (seconds) { return totalWorkedSeconds; }

            return (totalWorkedSeconds/60/60).toFixed(2)/1;

            // var hours = Math.trunc(totalWorkedSeconds/60/60);
            // var minutes = (totalWorkedSeconds/60) % 60;
            //
            // if (totalWorkedSeconds)
            // {
            //     return hours + ':' + (minutes < 10 ? '0' + minutes : minutes);
            // }
        };

        $scope.isOverTime = function(dayDetails, user)
        {
            var totalScheduledSeconds = 0;
            var totalWorkedSeconds = 0;

            var taskAssignments = $scope.getTaskAssignmentsForUser(dayDetails, user);
            var sheets = $scope.getTimeSheetsForUser(dayDetails, user);

            if (taskAssignments && sheets)
            {
                taskAssignments.map(function (assignment)
                {
                    totalScheduledSeconds += assignment.getSecondsScheduled();
                });

                sheets.map(function (sheet)
                {
                    totalWorkedSeconds += sheet.getSecondsWorked();
                });

                return totalWorkedSeconds > totalScheduledSeconds;
            }
            return false;
        };

        $scope.getTimeSheets = function(day)
        {
            if (!$scope.orgEnabled.constitutional)
            {
                return $scope.guideTimeSheetCollection.getTimeSheets(day, 2);
            } else if (!$scope.orgEnabled.spirits)
            {
                return $scope.guideTimeSheetCollection.getTimeSheets(day, 1);
            }

            return $scope.guideTimeSheetCollection.getTimeSheets(day);
        };

        $scope.getTaskAssignments = function(day)
        {
            if (!$scope.orgEnabled.constitutional)
            {
                return $scope.taskAssignmentCollection.getTaskAssignments(day, 2);
            } else if (!$scope.orgEnabled.spirits)
            {
                return $scope.taskAssignmentCollection.getTaskAssignments(day, 1);
            }
            return $scope.taskAssignmentCollection.getTaskAssignments(day);
        };

        $scope.getOrganization = function(id)
        {
            for (var i=0; i<$scope.organizationsCollection.organizations.length; i++)
            {
                if ($scope.organizationsCollection.organizations[i].id/1 === id/1)
                {
                    return $scope.organizationsCollection.organizations[i];
                }
            }
        };

        $scope.openSheetDetails = function(dayDetails, user)
        {
            if ($scope.getTimeWorked(dayDetails, user).realTime)
            {
                $scope.activeDetails = dayDetails;
                $scope.activeUser = user;
            }
        };

        $scope.getGuideAssignmentByTaskId = function(id)
        {
            return ($scope.guideAssignmentCollection.collection.filter(function(assignment)
            {
                return assignment.taskassignment_id/1 === id/1;
            })).pop();
        };

        $scope.isRenderingSlowed = function()
        {
            var start = new Date($scope.payPeriod.datePicker.start);
            var end   = new Date($scope.payPeriod.datePicker.end);

            var daysBetween = (Math.abs(start - end)/1000/60/60/24);
            return daysBetween >= 120;
        };


        $scope.downloadCsv = function()
        {
            var header = ['Date'];
            var startDate = $filter('date')($scope.payPeriod.activeDays[0].day, 'yyyy-MM-dd');
            var endDate = $filter('date')($scope.payPeriod.activeDays[$scope.payPeriod.activeDays.length - 1].day, 'yyyy-MM-dd');

            var sortedUsers = $scope.getFilteredUsers().sort(function(a, b)
            {
                return a.fullName > b.fullName ? 1 : -1;
            });

            sortedUsers.forEach(function(user)
            {
                header.push(user.name);
            });

            header.push('Day Total');

            var rows = [header];

            $scope.payPeriod.activeDays.forEach(function(dayDetails)
            {
                var pay_day_row = [$filter('date')(dayDetails.day, 'MMM dd yyyy')];

                sortedUsers.forEach(function(user)
                {
                    var timeWorked = $scope.getTimeWorked(dayDetails, user);

                    if (timeWorked && timeWorked.roundedTime)
                    {
                        pay_day_row.push(timeWorked.roundedTime);
                    } else if (timeWorked && timeWorked.realTime)
                    {
                        pay_day_row.push(timeWorked.realTime);
                    } else
                    {
                        pay_day_row.push('');
                    }
                });

                pay_day_row.push($scope.getDailyTotalHours(dayDetails));

                rows.push(pay_day_row);
            });

            var total_hours_row = ['Total Hours'];
            var hourly_rate_row = ['Hourly Rate'];
            var total_wages_row = ['Total Wages'];

            sortedUsers.forEach(function(user)
            {
                total_hours_row.push($scope.getTotalUserHours(user));
                hourly_rate_row.push($filter('currency')(user.rate));
                total_wages_row.push($filter('currency')($scope.getPayroll(user)));
            });

            total_hours_row.push($scope.getTotalHours());
            hourly_rate_row.push('');
            total_wages_row.push($filter('currency')($scope.getTotalPayroll()));


            rows.push(total_hours_row);
            rows.push(hourly_rate_row);
            rows.push(total_wages_row);

            var csvContent = "data:text/csv;charset=utf-8," +
                rows.map(function(e) { return e.join(","); }).join("\n");

            var encodedUri = encodeURI(csvContent);
            var link = document.createElement("a");
            link.setAttribute("href", encodedUri);
            link.setAttribute("download", "time_sheets" + startDate + '-' + endDate +".csv");
            document.body.appendChild(link); // Required for FF

            link.click();
        };

        var promises = [];

        promises.push($scope.usersCollection.load());
        promises.push($scope.organizationsCollection.load());
        promises.push($scope.taskTypesCollection.load());
        promises.push($scope.tourTypesCollection.load());

        $q.all(promises).then(function()
        {
            $scope.updatePayPeriod(0);
        });
    }]);


})($, angular, document, window);
