<?php

namespace Application\Services\Mail;

use Application\Model\EmailMessage;
use Application\Model\EmailTemplate;
use Application\Model\MessageRecipient;
use Application\Model\ReservedDate;
use Application\Model\ReservedDatesTable;
use Application\Model\User;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\View\Model\ViewModel;

class SaveTheDateMailer extends GenericMailerInterface
{
    /**
     * @param User $user
     * @param $emailData EmailMessage
     */
    public function sendMail(User $user, $emailData)
    {

        $config = $this->serviceLocator->get('config');
        $config = $config['smtp_service'];

        /**
         * @var $reservedDatesTable ReservedDatesTable
         */
        $reservedDatesTable = $this->serviceLocator->get('Application\Model\ReservedDatesTable');

        $failedEmails = [];
        $sentEmails = [];

        $startDate = strtotime($emailData->messageOptions->startDate);
        $endDate = strtotime($emailData->messageOptions->endDate);

        $toSaveDates = [];

        try {
            /**
             * @var $messageFooter EmailTemplate
             */
            $messageFooter = $this->serviceLocator->get('EmailFooterFactory');
            $messageFooter = $messageFooter->content;
            $messageHeader = $this->serviceLocator->get('EmailHeaderFactory');
            $messageHeader = $messageHeader->content;
        } catch (\Exception $e)
        {
            $messageFooter = '';
            $messageHeader = '';
        }

        /**
         * @var $messageRecipient MessageRecipient
         */
        foreach ($emailData->messageRecipients as $messageRecipient)
        {

            if (!$messageRecipient->enabled) { continue; }

            /**
             * FIXME: using hard-coded organization names
             */
            $organizationList = [];

            try {

                /**
                 * @var $reservedDatesCursor ResultSet
                 */
                $reservedDatesCursor = $reservedDatesTable->fetchCurrent($startDate, $endDate, $messageRecipient->id);

                /**
                 * @var $reservedDate ReservedDate
                 */
                while ($reservedDate = $reservedDatesCursor->current())
                {
                    if ($reservedDate->reserved)
                    {
                        if ($reservedDate->organization_id == 1 && $emailData->messageOptions->organizationId == 1)
                        {
                            $organizationList['The Constitutional'][] = strtotime($reservedDate->reserveddate);
                            $reservedDate->emaildate = date('Y-m-d H:i:s');
                            $toSaveDates[] = $reservedDate;
                        } else if ($reservedDate->organization_id == 2 && $emailData->messageOptions->organizationId == 2)
                        {
                            $organizationList['Spirits of 76'][] = strtotime($reservedDate->reserveddate);
                            $reservedDate->emaildate = date('Y-m-d H:i:s');
                            $toSaveDates[] = $reservedDate;
                        }
                    }
                    $reservedDate->reserveddate = strtotime($reservedDate->reserveddate);
                    $reservedDatesCursor->next();
                }

            } catch (\Exception $exception)
            {
                $failedEmails[] = $messageRecipient->name;
                continue;
            }

            foreach ($organizationList as $org => $reservedDateList)
            {
                sort($organizationList[$org]);
            }


            if (!sizeof($organizationList)) { continue; }

            $subject = 'SAVE THE DATE: ';

            if (array_key_exists('The Constitutional', $organizationList))
                $subject .= 'The Constitutional';

            if (array_key_exists('Spirits of 76', $organizationList))
            {
                if (array_key_exists('The Constitutional', $organizationList))
                {
                    $subject .= ', ';
                }
                $subject .= 'Spirits of 76';
            }

            $viewModel = new ViewModel();
            $viewModel->setTemplate('messaging/save-the-date')
                ->setVariables([
                    'startDate' => $startDate,
                    'endDate' => $endDate,
                    'organizationList' => $organizationList,
                    'user' => $messageRecipient->name,
                    'messageHeader' => $messageHeader,
                    'messageFooter' => $messageFooter
                ]);

            $this->getMimeMessage(true)->addPart($this->getHtmlPart($viewModel, true));

            $mail = $this->getMailMessage(true);
            $mail->setFrom($config['default_from']);

            if (APPLICATION_ENVIRONMENT == 'production')
            {
                $mail->setTo(sprintf("%s <%s>", $messageRecipient->name, $messageRecipient->email));
            } else
            {
                $mail->setTo($config['debug_from']);
            }
            $mail->setBcc($user->email);
            $mail->setSubject($subject);
            $mail->setBody($this->getMimeMessage());

            $this->dispatchMail();

            $sentEmails[] = $messageRecipient->name;
        }

        $emailData->messageSubject = '';
        $emailData->messageBody = "Save the date messages sent\n\n\n";
        $emailData->messageBody .= sizeof($failedEmails) ?
            sprintf("Failed Messages: %s\n\n", implode(", ", $failedEmails)) : '';

        try
        {
            foreach ($toSaveDates as $reservedDate)
            {
                $reservedDate->reserveddate = date('Y-m-d', $reservedDate->reserveddate);
                $reservedDatesTable->saveOne($reservedDate);
            }
        } catch (\Exception $e) {};
    }
}
