<?php

namespace Application\Model;

use Laminas\Crypt\Password\BcryptSha;

class User extends StandardEntry
{
    const LOGIN_ATTEMPTS_ALLOWED = 5;

    public $id;
    public $name;
    public $homephone;
    public $cellphone;
    public $email;
    public $rate;
    public $username;
    public $password;
    public $numlogins;
    public $lastlog;
    public $status;
    public $create_date;
    public $modify_date;
    public $passwordchangerequired;
    public $organization_constitutional;
    public $organization_spirits;
    public $salt;
    public $passwd_reset_key;
    public $login_tries;

    public function toArray()
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'homephone' => $this->homephone,
            'cellphone' => $this->cellphone,
            'email' => $this->email,
            'rate' => $this->rate,
            'username' => $this->username,
            'password' => $this->password,
            'numlogins' => $this->numlogins,
            'lastlog' => $this->lastlog,
            'status' => $this->status,
            'create_date' => $this->create_date,
            'modify_date' => $this->modify_date,
            'passwordchangerequired' => $this->passwordchangerequired,
            'organization_constitutional' => $this->organization_constitutional,
            'organization_spirits' => $this->organization_spirits,
            'salt' => $this->salt,
            'passwd_reset_key' => $this->passwd_reset_key,
            'login_tries' => $this->login_tries
        ];
    }


    public function encryptPassword($password = null)
    {
        if ($password != null)
        {
            $this->password = $password;
        }

        $this->salt = $this->salt ? $this->salt : self::createSalt();

        $bcrypt = new BcryptSha();
        $bcrypt->setSalt($this->salt);

        $this->password = $bcrypt->create($this->password);
        return $this->password;
    }

    public static function createSalt()
    {
        return sha1(self::generatePassword() . self::generatePassword());
    }

    public static function generatePassword()
    {
        $passwd_chrs = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $passwd = "";

        while (strlen($passwd) < 16)
        {
            $num = mt_rand(0, strlen($passwd_chrs));

            $passwd .= substr($passwd_chrs, $num, 1);
        }
        return $passwd;
    }

    /**
     * Return the user's identifier.
     *
     * @return mixed
     */
    public function getIdentifier()
    {
        return sha1($this->email);
    }

    public function passwordOkay($password)
    {
        return strlen($password) >= 8 &&
            preg_match("/[a-z]{1,}/", $password) &&
            preg_match("/[A-Z]{1,}/", $password) &&
            preg_match("/[0-9]{1,}/", $password) &&
            preg_match('/[\W]{1,}/', $password);
    }
}


