<?php

namespace Application\Model;

class ShiftAssignmentsTable extends StandardTable
{

    public function fetchList($weekdayAssignmentId, $shiftAssignmentIds)
    {
        return $this->tableGateway->select(function($select) use ($weekdayAssignmentId, $shiftAssignmentIds)
        {
            if ((int) $weekdayAssignmentId > 0)
                $select->where(['weekdayassignment_id' => (int) $weekdayAssignmentId]);

            if (is_array($shiftAssignmentIds) && sizeof($shiftAssignmentIds) > 0)
                $select->where->in('id', $shiftAssignmentIds);

            return $select;
        });
    }

    public function deleteMatching(WeekdayAssignment $weekdayAssignment)
    {
        return $this->tableGateway->delete(['weekdayassignment_id' => $weekdayAssignment->id]);
    }
}