<?php

namespace Application\Model;

class ReservedDatesTable extends StandardTable
{

    public function fetchCurrent($startDate, $endDate, $userId = null)
    {
        return $this->tableGateway->select(function($select) use ($startDate, $endDate, $userId)
        {

            if ($startDate) $select->where->greaterThanOrEqualTo('reserveddate', date("Y-m-d", $startDate));
            if ($endDate) $select->where->lessThanOrEqualTo('reserveddate', date("Y-m-d", $endDate));

            if ($userId) $select->where(['guide_id' => (int) $userId]);

            return $select;
        });
    }
}