<?php

namespace Application\Model;

class GuideAvailabilityTable extends StandardTable {
	public function fetchAllByGuideId($guide_id, $startDate, $endDate) {
		return $this->tableGateway->select(function ($select) use ($guide_id, $startDate, $endDate) {
			if ($startDate) {
				$select->where->greaterThanOrEqualTo('availabilitydate', date("Y-m-d", $startDate));
			}

			if ($endDate) {
				$select->where->lessThanOrEqualTo('availabilitydate', date("Y-m-d", $endDate));
			}

			if ((int) $guide_id > 0) {
				return $select->where(['guide_id' => (int) $guide_id]);
			} else {
				return $select;
			}

		});
	}

	public function deleteLinked($create_date) {
		return $this->tableGateway->delete(['createdate' => $create_date, 'custom' => 0]);
	}
}
