<?php

namespace Application\Factories\Model;

use Laminas\Db\ResultSet\ResultSet;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

abstract class AbstractTableServiceFactory implements FactoryInterface
{


    public function buildService(ServiceLocatorInterface $serviceLocator,
        $arrayObjectPrototype, $tableName, $tablePrototype)
    {
        $dbAdapter = $serviceLocator->get('Laminas\Db\Adapter\Adapter');
        $resultSetPrototype = new ResultSet();
        $resultSetPrototype->setArrayObjectPrototype(new $arrayObjectPrototype);
        $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetPrototype);
        $table = new $tablePrototype($tableGateway, $serviceLocator);
        return $table;
    }
}