<?php

namespace Application\Factories\Mail\Services;

use Application\Services\Mail\SimpleEmailMessage;
use Application\Services\Mail\NullMailer;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class SimpleEmailMessageFactory implements FactoryInterface
{
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $config = $serviceLocator->get('config');
        $disableMail = $config['smtp_service']['disable_user_mail'];
        if ($disableMail)
        {
            $mailer = new NullMailer($serviceLocator);
            return $mailer;
        }
        $mailer = new SimpleEmailMessage($serviceLocator);
        return $mailer;
    }
}