<?php

namespace Application\Factories\Mail\Services;

use Application\Services\Mail\NullMailer;
use Application\Services\Mail\SaveTheDateMailer;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class SaveTheDateMailerFactory implements FactoryInterface
{
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $config = $serviceLocator->get('config');
        $disableMail = $config['smtp_service']['disable_user_mail'];
        if ($disableMail)
        {
            $mailer = new NullMailer($serviceLocator);
            return $mailer;
        }
        $mailer = new SaveTheDateMailer($serviceLocator);
        return $mailer;
    }
}