<?php

namespace Application\Factories\Mail\Services\Cron;

use Application\Services\Mail\NullMailer;
use Application\Services\Mail\Cron\ThankYouDaily;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class ThankYouDailyFactory implements FactoryInterface
{
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $config = $serviceLocator->get('config');
        $disableMail = $config['smtp_service']['disable_user_mail'];
        if ($disableMail)
        {
            $mailer = new NullMailer($serviceLocator);
            return $mailer;
        }
        $mailer = new ThankYouDaily($serviceLocator);
        return $mailer;
    }
}