<?php

namespace Application\Factories\Mail\Services\Cron;

use Application\Services\Mail\Cron\TaskScheduleDailyMailer;
use Application\Services\Mail\NullMailer;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class TaskScheduleDailyMailerFactory implements FactoryInterface
{
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $config = $serviceLocator->get('config');
        $disableMail = $config['smtp_service']['disable_admin_mail'];
        if ($disableMail)
        {
            $mailer = new NullMailer($serviceLocator);
            return $mailer;
        }
        $mailer = new TaskScheduleDailyMailer($serviceLocator);
        return $mailer;
    }
}