<?php

namespace Application\Factories\Mail;

use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;
use Laminas\View\Resolver\TemplateMapResolver;

class MailTemplateMapResolverFactory implements FactoryInterface
{
    static $service = null;

    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$service == null)
        {
            $config = $serviceLocator->get('config');

            $resolver = new TemplateMapResolver();
            $resolver->setMap($config['mail_template_map_resolver']);
            self::$service = $resolver;
        }
        return self::$service;
    }
}