<?php

namespace Application\Factories;

use Application\Exception\EntryNotFoundException;
use Application\Model\User;
use Laminas\ServiceManager\FactoryInterface;
use Laminas\ServiceManager\ServiceLocatorInterface;

class ActiveUserFactory implements FactoryInterface
{

    static $user = null;

    /**
     * @param ServiceLocatorInterface $serviceLocator
     * @return User
     * @throws EntryNotFoundException
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        if (self::$user == null)
        {
            try
            {
                $user = new User();
                $user->username = $serviceLocator->get('AuthService')->getIdentity();

                /**
                 * @var $user User
                 */
                self::$user = $serviceLocator->get('Application\Model\UserTable')->findMatchingUser($user);

            } catch (\Exception $e)
            {
                throw new EntryNotFoundException($e->getMessage(), $e->getCode(), $e);
            }
        }
        return self::$user;
    }
}