<?php

namespace Application\Controller;

use Application\Model\EmailTemplate;
use Application\Model\GuideAssignment;
use Application\Model\GuideAssignmentTable;
use Application\Model\TaskAssignment;
use Application\Model\TaskAssignmentTable;
use Application\Model\TaskType;
use Application\Model\TaskTypesTable;
use Application\Model\TourType;
use Application\Model\TourTypesTable;
use Application\Model\User;
use Application\Model\UserTable;
use Laminas\Mvc\Controller\AbstractActionController;

class TourDataExportToCSVController extends AbstractActionController
{
    /**
     * @var User[]
     */
    private $usersList = null;

    /**
     * @var TaskType[]
     */
    private $taskTypeList = null;

    /**
     * @var TourType[]
     */
    private $tourTypeList = null;

    /**
     * @return User[]|null
     */
    private function getUsers()
    {
        if ($this->usersList === null) {
            $this->usersList = [];

            /**
             * @var $usersTable UserTable
             */
            $usersTable = $this->serviceLocator->get('Application\Model\UserTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $usersTable->getLiveUsers();

            /**
             * @var $user User
             */
            while ($user = $resultSet->current()) {
                $this->usersList[$user->id] = $user;
                $resultSet->next();
            }
        }

        return $this->usersList;
    }

    /**
     * @param $id
     * @return User
     */
    private function getUser($id)
    {
        $usersList = $this->getUsers();

        if (array_key_exists($id, $usersList) && $usersList[$id] instanceof User) {
            return $usersList[$id];
        }

        $noUser = new User();
        $noUser->name = sprintf('Unknown User (id: %d)', $id);
        return $noUser;
    }

    /**
     * @param TaskAssignment $taskAssignment
     * @return User[]
     */
    private function getAssignedGuides(TaskAssignment $taskAssignment)
    {

        /**
         * @var $guideAssignmentsTable GuideAssignmentTable
         */
        $guideAssignmentsTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

        /**
         * @var $guideAssignmentsResultSet ResultSet
         */
        $guideAssignmentsResultSet = $guideAssignmentsTable->fetchAllByAssignmentIds([$taskAssignment->id], 1);

        $assigned_guides = [];

        /**
         * @var $guideAssignment GuideAssignment
         */
        while ($guideAssignment = $guideAssignmentsResultSet->current()) {
            $assigned_guides[] = $this->getUser($guideAssignment->guide_id);
            $guideAssignmentsResultSet->next();
        }

        return $assigned_guides;
    }

    /**
     * @return TaskType[]
     */
    private function getTaskTypeList()
    {
        if ($this->taskTypeList == null) {
            $this->taskTypeList = [];

            /**
             * @var $taskTypeTable TaskTypesTable
             */
            $taskTypeTable = $this->serviceLocator->get('Application\Model\TaskTypeTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $taskTypeTable->fetchAll();

            /**
             * @var $taskType TaskType
             */
            while ($taskType = $resultSet->current()) {
                $this->taskTypeList[$taskType->id] = $taskType;
                $resultSet->next();
            }
        }

        return $this->taskTypeList;
    }

    /**
     * @param $id
     * @return TaskType
     */
    private function getTaskType($id)
    {
        $taskTypes = $this->getTaskTypeList();

        if (array_key_exists($id, $taskTypes) && $taskTypes[$id] instanceof TaskType) {
            return $taskTypes[$id];
        }

        $taskType = new TaskType();
        $taskType->name = 'Unknown Task Type';
        return $taskType;
    }

    /**
     * @return TourType[]|array
     */
    private function getTourTypeList()
    {
        if ($this->tourTypeList == null) {
            $this->tourTypeList = [];

            /**
             * @var $tourTypeTable TourTypesTable
             */
            $tourTypeTable = $this->serviceLocator->get('Application\Model\TourTypeTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $tourTypeTable->fetchAll();

            /**
             * @var $tourType TourType
             */
            while ($tourType = $resultSet->current()) {
                $this->tourTypeList[$tourType->id] = $tourType;
                $resultSet->next();
            }
        }

        return $this->tourTypeList;
    }

    /**
     * @param $id
     * @return TourType
     */
    private function getTourType($id)
    {
        $tourTypes = $this->getTourTypeList();

        if (array_key_exists($id, $tourTypes) && $tourTypes[$id] instanceof TourType) {
            return $tourTypes[$id];
        }

        $tourType = new TourType();
        $tourType->name = 'Unknown Tour Type';
        return $tourType;
    }

    public function indexAction()
    {
        if ($_GET['emailsend'] == 1) {

            error_reporting(E_ALL|E_STRICT);
            ini_set('display_errors', 'on');

            /**
             * @var $taskAssignmentTable TaskAssignmentTable
             */
            $taskAssignmentTable = $this->serviceLocator->get('Application\Model\TaskAssignmentTable');

            $startDate = strtotime("now");

            /**
             * @var $taskAssignmentsResultSet ResultSet
             */
            $taskAssignmentsResultSet = $taskAssignmentTable->get_all_records($startDate, null, null, null);

            $failed_list = [];
            $completed_list = [];


            $futureScheduleTasks = [];

            /**
             * @var $taskAssignment TaskAssignment
             */
            while ($taskAssignment = $taskAssignmentsResultSet->current()) {
                try {
                    /**
                     * @var $taskType TaskType
                     */
                    $taskType = $this->getTaskType($taskAssignment->tasktype);

                    /**
                     * @var $tourType TourType
                     */
                    $tourType = $this->getTourType($taskAssignment->tourtype);


                    $guidesAssigned = $this->getAssignedGuides($taskAssignment);

                    /**
                     * If no guides are assigned, skip this task
                     */
                    if (!is_array($guidesAssigned)) {
                        $taskAssignmentsResultSet->next();
                        continue;
                    }

                    $taskData = new \stdClass();
                    $taskData->taskAssignment = $taskAssignment;
                    $taskData->taskType = $taskType;
                    $taskData->tourType = $tourType;
                    $taskData->assignedGuides = $guidesAssigned;

                    $futureScheduleTasks[] = $taskData;

                    $completed_list[] = $taskAssignment;
                } catch (\Exception $exception) {
                    $failed_list[] = $taskAssignment;
                }

                $taskAssignmentsResultSet->next();
            }
            $activeUser = $this->serviceLocator->get('ActiveUser');

            $futureScheduleSendEmail = $this->serviceLocator->get('Application\Services\Mail\TourDataExportMailer');
            $futureScheduleSendEmail->sendMail($activeUser, $futureScheduleTasks);


            return [$completed_list, $failed_list];
        }
    }
}
