<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\Task;
use Application\Model\TasksTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class TasksController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $tasksTable TasksTable
             */
            $tasksTable = $this->serviceLocator->get('Application/Model/TasksTable');

            /**
             * @var $task Task
             */
            $task = $tasksTable->fetchOne($id);

            return new JsonModel($task->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $tasksTable TasksTable
             */
            $tasksTable = $this->serviceLocator->get('Application/Model/TasksTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $tasksTable->fetchAll();

            $return = [];

            /**
             * @var $task Task
             */
            while ($task = $resultSet->current())
            {
                $return[] = $task->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $tasksTable TasksTable
             */
            $tasksTable = $this->serviceLocator->get('Application/Model/TasksTable');

            $task = new Task();
            $task->exchangeArray($data);
            $task->id = null;
            $task->createdate = date("Y-m-d");
            $task->modifydate = date("Y-m-d");

            $tasksTable->saveOne($task);

            return new JsonModel($task->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $tasksTable TasksTable
             */
            $tasksTable = $this->serviceLocator->get('Application/Model/TasksTable');

            $task = new Task();
            $task->exchangeArray($data);

            /**
             * @var $oldTask Task
             */
            $oldTask = $tasksTable->fetchOne($id);

            $task->createdate = $oldTask->createdate;
            $task->modifydate = date("Y-m-d");

            $tasksTable->saveOne($task);

            return new JsonModel($task->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $tasksTable TasksTable
             */
            $tasksTable = $this->serviceLocator->get('Application/Model/TasksTable');

            $tasksTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Deleted Task"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}