<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\TaskType;
use Application\Model\TaskTypesTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class TaskTypeController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $taskTypeTable TaskTypesTable
             */
            $taskTypeTable = $this->serviceLocator->get('Application/Model/TaskTypeTable');

            /**
             * @var $taskType TaskType
             */
            $taskType = $taskTypeTable->fetchOne($id);

            return new JsonModel($taskType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {

            /**
             * @var $taskTypeTable TaskTypesTable
             */
            $taskTypeTable = $this->serviceLocator->get('Application/Model/TaskTypeTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $taskTypeTable->fetchAll();

            $return = [];

            /**
             * @var $taskType TaskType
             */
            while ($taskType = $resultSet->current())
            {
                $return[] = $taskType->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {


            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }


            /**
             * @var $taskTypeTable TaskTypesTable
             */
            $taskTypeTable = $this->serviceLocator->get('Application/Model/TaskTypeTable');

            $taskType = new TaskType();
            $taskType->exchangeArray($data);
            $taskType->id = null;

            $taskTypeTable->saveOne($taskType);

            return new JsonModel($taskType->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {


            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');


            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $taskTypeTable TaskTypesTable
             */
            $taskTypeTable = $this->serviceLocator->get('Application/Model/TaskTypeTable');

            $toUpdateTaskType = new TaskType();
            $toUpdateTaskType->exchangeArray($data);


            $taskTypeTable->saveOne($toUpdateTaskType);

            return new JsonModel($toUpdateTaskType->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $taskTypeTable TaskTypesTable
             */
            $taskTypeTable = $this->serviceLocator->get('Application/Model/TaskTypeTable');


            $taskTypeTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Task Type Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}