<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\ShiftAssignment;
use Application\Model\ShiftAssignmentsTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class ShiftAssignmentsController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $shiftAssignmentsTable ShiftAssignmentsTable
             */
            $shiftAssignmentsTable = $this->serviceLocator->get('Application\Model\ShiftAssignmentsTable');

            /**
             * @var $shiftAssignment ShiftAssignment
             */
            $shiftAssignment = $shiftAssignmentsTable->fetchOne($id);

            return new JsonModel($shiftAssignment->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $shiftAssignmentsTable ShiftAssignmentsTable
             */
            $shiftAssignmentsTable = $this->serviceLocator->get('Application\Model\ShiftAssignmentsTable');

            $weekdayAssignmentId = $this->request->getQuery('weekdayAssignmentId', null);
            $shiftAssignmentIds = $this->request->getQuery('shiftAssignmentIds', null);
            $shiftAssignmentIds = $shiftAssignmentIds && $shiftAssignmentIds !== 'null' ? preg_split("/,/", $shiftAssignmentIds) : null;


            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $shiftAssignmentsTable->fetchList($weekdayAssignmentId, $shiftAssignmentIds);

            $return = [];

            /**
             * @var $shiftAssignment ShiftAssignment
             */
            while ($shiftAssignment = $resultSet->current())
            {
                $return[] = $shiftAssignment->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $shiftAssignmentsTable ShiftAssignmentsTable
             */
            $shiftAssignmentsTable = $this->serviceLocator->get('Application\Model\ShiftAssignmentsTable');

            $shiftAssignment = new ShiftAssignment();
            $shiftAssignment->exchangeArray($data);
            $shiftAssignment->id = null;
            $shiftAssignment->guide_id = (int) $shiftAssignment->guide_id > 0 ? $shiftAssignment->guide_id : null;
            $shiftAssignment->shift_id = (int) $shiftAssignment->shift_id > 0 ? $shiftAssignment->shift_id : null;
            $shiftAssignment->weekdayassignment_id = (int) $shiftAssignment->weekdayassignment_id > 0 ?
                $shiftAssignment->weekdayassignment_id : null;

            $shiftAssignmentsTable->saveOne($shiftAssignment);

            return new JsonModel($shiftAssignment->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $shiftAssignmentsTable ShiftAssignmentsTable
             */
            $shiftAssignmentsTable = $this->serviceLocator->get('Application\Model\ShiftAssignmentsTable');

            $shiftAssignment = new ShiftAssignment();
            $shiftAssignment->exchangeArray($data);
            $shiftAssignment->guide_id = (int) $shiftAssignment->guide_id > 0 ? $shiftAssignment->guide_id : null;
            $shiftAssignment->shift_id = (int) $shiftAssignment->shift_id > 0 ? $shiftAssignment->shift_id : null;
            $shiftAssignment->weekdayassignment_id = (int) $shiftAssignment->weekdayassignment_id > 0 ?
                $shiftAssignment->weekdayassignment_id : null;

            $shiftAssignmentsTable->saveOne($shiftAssignment);

            return new JsonModel($shiftAssignment->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $shiftAssignmentsTable ShiftAssignmentsTable
             */
            $shiftAssignmentsTable = $this->serviceLocator->get('Application\Model\ShiftAssignmentsTable');

            $shiftAssignmentsTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Shift Assignment Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}
