<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\Organization;
use Application\Model\OrganizationsTable;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class OrganizationController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {

            /**
             * @var $OrganizationsTable OrganizationsTable
             */
            $OrganizationsTable = $this->serviceLocator->get('Application/Model/OrganizationsTable');

            /**
             * @var $organization Organization
             */
            $organization = $OrganizationsTable->fetchOne($id);

            return new JsonModel($organization->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $OrganizationsTable OrganizationsTable
             */
            $OrganizationsTable = $this->serviceLocator->get('Application/Model/OrganizationsTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $OrganizationsTable->fetchAll();

            $return = [];

            /**
             * @var $organization Organization
             */
            while ($organization = $resultSet->current())
            {
                $return[] = $organization->toArray();
                $resultSet->next();
            }

            return new JsonModel($return);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {
            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }


            /**
             * @var $OrganizationsTable OrganizationsTable
             */
            $OrganizationsTable = $this->serviceLocator->get('Application/Model/OrganizationsTable');

            $organization = new Organization();
            $organization->exchangeArray($data);
            $organization->id = null;

            $OrganizationsTable->saveOne($organization);

            return new JsonModel($organization->toArray());

        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');


            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $OrganizationsTable OrganizationsTable
             */
            $OrganizationsTable = $this->serviceLocator->get('Application/Model/OrganizationsTable');

            $toUpdateOrganization = new Organization();
            $toUpdateOrganization->exchangeArray($data);

            /**
             * @var $oldOrganization Organization
             */
            $oldOrganization = $OrganizationsTable->fetchOne($id);
            $oldOrganization->name = $toUpdateOrganization->name;

            $OrganizationsTable->saveOne($oldOrganization);

            return new JsonModel($oldOrganization->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            if (!$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            /**
             * @var $OrganizationsTable OrganizationsTable
             */
            $OrganizationsTable = $this->serviceLocator->get('Application/Model/OrganizationsTable');


            $OrganizationsTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Organization Deleted"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}