<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\GuideTimeSheet;
use Application\Model\GuideTimeSheetsTable;
use Application\Model\User;
use Application\Services\DatePickerFormatter;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class GuideTimeSheetsController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $guideTimeSheetsTable GuideTimeSheetsTable
             */
            $guideTimeSheetsTable = $this->serviceLocator->get('Application\Model\GuideTimeSheetsTable');

            /**
             * @var $guideTimeSheet GuideTimeSheet
             */
            $guideTimeSheet = $guideTimeSheetsTable->fetchOne($id);
            $guideTimeSheet->assignmentdate = DatePickerFormatter::toDatePickerDate($guideTimeSheet->assignmentdate);

            return new JsonModel($guideTimeSheet->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {
            /**
             * @var $guideTimeSheetsTable GuideTimeSheetsTable
             */
            $guideTimeSheetsTable = $this->serviceLocator->get('Application\Model\GuideTimeSheetsTable');

            $startDate = $this->request->getQuery('startDate', 'now');
            $endDate = $this->request->getQuery('endDate', 'now');

            $startDate = strtotime($startDate);
            $endDate = strtotime($endDate);

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $guideTimeSheetsTable->fetchCurrent($startDate, $endDate);

            $results = [];

            /**
             * @var $guideTimeSheet GuideTimeSheet
             */
            while ($guideTimeSheet = $resultSet->current())
            {
                $guideTimeSheet->assignmentdate = DatePickerFormatter::toDatePickerDate($guideTimeSheet->assignmentdate);
                $results[] = $guideTimeSheet->toArray();
                $resultSet->next();
            }

            return new JsonModel($results);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {

            /**
             * @var $activeUser User
             */
            $activeUser = $this->serviceLocator->get('ActiveUser');

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            /**
             * @var $guideTimeSheetsTable GuideTimeSheetsTable
             */
            $guideTimeSheetsTable = $this->serviceLocator->get('Application\Model\GuideTimeSheetsTable');

            $guideTimeSheet = new GuideTimeSheet();
            $guideTimeSheet->exchangeArray($data);
            $guideTimeSheet->id = null;
            $guideTimeSheet->assignmentdate = DatePickerFormatter::toSqlDate($guideTimeSheet->assignmentdate);
            $guideTimeSheet->modifydate = date('Y-m-d H:i:s');
            $guideTimeSheet->createdate = date('Y-m-d H:i:s');
            $guideTimeSheet->starttime_5 = $guideTimeSheet->starttime_5 ?: null;
            $guideTimeSheet->starttime_4 = $guideTimeSheet->starttime_4 ?: null;
            $guideTimeSheet->starttime_3 = $guideTimeSheet->starttime_3 ?: null;
            $guideTimeSheet->starttime_2 = $guideTimeSheet->starttime_2 ?: null;
            $guideTimeSheet->starttime_1 = $guideTimeSheet->starttime_1 ?: null;
            $guideTimeSheet->endtime_5 = $guideTimeSheet->endtime_5 ?: null;
            $guideTimeSheet->endtime_4 = $guideTimeSheet->endtime_4 ?: null;
            $guideTimeSheet->endtime_3 = $guideTimeSheet->endtime_3 ?: null;
            $guideTimeSheet->endtime_2 = $guideTimeSheet->endtime_2 ?: null;
            $guideTimeSheet->endtime_1 = $guideTimeSheet->endtime_1 ?: null;

            if ($activeUser->id != $guideTimeSheet->guide_id && !$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            $guideTimeSheetsTable->saveOne($guideTimeSheet);

            $guideTimeSheet->assignmentdate = DatePickerFormatter::toDatePickerDate($guideTimeSheet->assignmentdate);

            return new JsonModel($guideTimeSheet->toArray());
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {

            /**
             * @var $activeUser User
             */
            $activeUser = $this->serviceLocator->get('ActiveUser');

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            /**
             * @var $guideTimeSheetsTable GuideTimeSheetsTable
             */
            $guideTimeSheetsTable = $this->serviceLocator->get('Application\Model\GuideTimeSheetsTable');

            /**
             * @var $oldSheet GuideTimeSheet
             */
            $oldSheet = $guideTimeSheetsTable->fetchOne($id);

            $guideTimeSheet = new GuideTimeSheet();
            $guideTimeSheet->exchangeArray($data);
            $guideTimeSheet->createdate = $oldSheet->createdate;
            $guideTimeSheet->modifydate = date('Y-m-d H:i:s');

            if ($activeUser->id != $guideTimeSheet->guide_id && !$activeAdmin->enabled)
            {
                return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }

            $guideTimeSheet->starttime_5 = $guideTimeSheet->starttime_5 ?: null;
            $guideTimeSheet->starttime_4 = $guideTimeSheet->starttime_4 ?: null;
            $guideTimeSheet->starttime_3 = $guideTimeSheet->starttime_3 ?: null;
            $guideTimeSheet->starttime_2 = $guideTimeSheet->starttime_2 ?: null;
            $guideTimeSheet->starttime_1 = $guideTimeSheet->starttime_1 ?: null;
            $guideTimeSheet->endtime_5 = $guideTimeSheet->endtime_5 ?: null;
            $guideTimeSheet->endtime_4 = $guideTimeSheet->endtime_4 ?: null;
            $guideTimeSheet->endtime_3 = $guideTimeSheet->endtime_3 ?: null;
            $guideTimeSheet->endtime_2 = $guideTimeSheet->endtime_2 ?: null;
            $guideTimeSheet->endtime_1 = $guideTimeSheet->endtime_1 ?: null;


            $guideTimeSheet->assignmentdate = DatePickerFormatter::toSqlDate($guideTimeSheet->assignmentdate);
            $guideTimeSheetsTable->saveOne($guideTimeSheet);
            $guideTimeSheet->assignmentdate = DatePickerFormatter::toDatePickerDate($guideTimeSheet->assignmentdate);


            return new JsonModel($guideTimeSheet->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $guideTimeSheetsTable GuideTimeSheetsTable
             */
            $guideTimeSheetsTable = $this->serviceLocator->get('Application\Model\GuideTimeSheetsTable');

            $guideTimeSheetsTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Guide Time Sheet removed"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}
