<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use API\Exception\DeletedEntryNotificationException;
use API\Exception\SystemErrorException;
use Application\Exception\EntryNotFoundException;
use Application\Model\Admin;
use Application\Model\GuideAssignment;
use Application\Model\GuideAssignmentTable;
use Application\Model\GuideAssignmentTicket;
use Application\Model\GuideAssignmentTicketTable;
use Application\Model\User;
use Laminas\Db\ResultSet\ResultSet;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class GuideAssignmentTicketsController extends AbstractRestfulController
{
    public function get($id)
    {
        try
        {
            /**
             * @var $guideAssignmentTicketTable GuideAssignmentTicketTable
             */
            $guideAssignmentTicketTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTicketTable');

            /**
             * @var $guideAssignmentTicket GuideAssignmentTicket
             */
            $guideAssignmentTicket = $guideAssignmentTicketTable->fetchOne($id);

            return new JsonModel($guideAssignmentTicket->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function getList()
    {
        try
        {

            $assignmentIds = $this->request->getPost('assignmentIds', []);

            /**
             * @var $guideAssignmentTicketTable GuideAssignmentTicketTable
             */
            $guideAssignmentTicketTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTicketTable');

            /**
             * @var $resultSet ResultSet
             */
            $resultSet = $guideAssignmentTicketTable->fetchAllByAssignmentIds($assignmentIds);

            $results = [];

            /**
             * @var $guideAssignmentTicket GuideAssignmentTicket
             */
            while ($guideAssignmentTicket = $resultSet->current())
            {
                $results[] = $guideAssignmentTicket->toArray();
                $resultSet->next();
            }

            return new JsonModel($results);

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function create($data)
    {
        try
        {

            $assignmentIds = $this->request->getPost('assignmentIds', []);

            if (sizeof($assignmentIds))
            {
                return $this->getList();
            }

            /**
             * @var $activeUser User
             */
            $activeUser = $this->serviceLocator->get('ActiveUser');

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            /**
             * FIXME: make sure user has permission to create ticket
             */

            /**
             * @var $guideAssignmentTicketTable GuideAssignmentTicketTable
             */
            $guideAssignmentTicketTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTicketTable');


            $guideAssignmentTicket = new GuideAssignmentTicket();
            $guideAssignmentTicket->exchangeArray($data);
            $guideAssignmentTicket->id = null;

            if (!$activeAdmin->enabled)
            {
                /**
                 * @var $guideAssignmentTable GuideAssignmentTable
                 */
                $guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

                /**
                 * @var $guideAssignment GuideAssignment
                 */
                $guideAssignment = $guideAssignmentTable->fetchOne($guideAssignmentTicket->assignment_id);

                if ($guideAssignment->guide_id !== $activeUser->id)
                    return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }


            $guideAssignmentTicketTable->saveOne($guideAssignmentTicket);

            return new JsonModel($guideAssignmentTicket->toArray());
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function update($id, $data)
    {
        try
        {
            /**
             * FIXME: make sure the user has permission to update a ticket
             */

            /**
             * @var $activeUser User
             */
            $activeUser = $this->serviceLocator->get('ActiveUser');

            /**
             * @var $activeAdmin Admin
             */
            $activeAdmin = $this->serviceLocator->get('ActiveAdmin');

            /**
             * @var $guideAssignmentTicketTable GuideAssignmentTicketTable
             */
            $guideAssignmentTicketTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTicketTable');

            $guideAssignmentTicket = new GuideAssignmentTicket();
            $guideAssignmentTicket->exchangeArray($data);

            if (!$activeAdmin->enabled)
            {
                /**
                 * @var $guideAssignmentTable GuideAssignmentTable
                 */
                $guideAssignmentTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTable');

                /**
                 * @var $guideAssignment GuideAssignment
                 */
                $guideAssignment = $guideAssignmentTable->fetchOne($guideAssignmentTicket->assignment_id);

                if ($guideAssignment->guide_id !== $activeUser->id)
                    return new JsonModel(new AccessDeniedException($this->response, 'Administrative Access Required'));
            }


            $guideAssignmentTicketTable->saveOne($guideAssignmentTicket);

            return new JsonModel($guideAssignmentTicket->toArray());

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }
    }

    public function delete($id)
    {
        try {
            /**
             * @var $guideAssignmentTicketTable GuideAssignmentTicketTable
             */
            $guideAssignmentTicketTable = $this->serviceLocator->get('Application\Model\GuideAssignmentTicketTable');

            $guideAssignmentTicketTable->deleteOne($id);

            return new JsonModel(new DeletedEntryNotificationException($this->response, "Guide Assignment removed"));

        } catch (EntryNotFoundException $notFoundException)
        {
            return new \API\Exception\EntryNotFoundException($this->response,
                "UNABLE TO FIND ENTRY");
        } catch (\Exception $exception)
        {
            return new JsonModel(new SystemErrorException($this->response, $exception));
        }

    }
}
