<?php

namespace API\Controller;

use API\Exception\AccessDeniedException;
use Application\Services\Mail\GenericMailerInterface;
use Laminas\Mvc\Controller\AbstractRestfulController;
use Laminas\View\Model\JsonModel;

class AutomatedEmailController extends AbstractRestfulController
{
    public function get($id)
    {

        try
        {
            /**
             * @var $mailerService GenericMailerInterface
             */
            $mailerService = $this->serviceLocator->get('Application\Services\Mail\Cron\\' . $id);
        } catch (\Exception $exception)
        {
            return new JsonModel(new AccessDeniedException($this->response, $exception));
        }
        $mailerService->executeCronAction();
    }
}