<?php
/**
 * Global Configuration Override
 *
 * You can use this file for overriding configuration values from modules, etc.
 * You would place values in here that are agnostic to the environment and not
 * sensitive to security.
 *
 * @NOTE: In practice, this file will typically be INCLUDED in your source
 * control, so do not include passwords or other sensitive information in this
 * file.
 */

function buildPath($name)
{
    return __DIR__ . '/../../module/Application/view/partials/mail/' . $name;
}
return [
    'service_manager' => [
        'factories' => [
            'Laminas\Db\Adapter\Adapter' => 'Laminas\Db\Adapter\AdapterServiceFactory',
        ],
        'abstract_factories' => [
            'Laminas\Cache\Service\StorageCacheAbstractServiceFactory'
        ]
    ],
    'smtp_service' => [
        'disable_user_mail' => false,
        'disable_admin_mail' => false,
        'default_from' => 'The Constitutional <leslie@theconstitutional.com>',
        'debug_from' => 'The Constitutional <leslie@theconstitutional.com>',
    ],
    'mail_template_map_resolver' => [
        'mail-layout'                     => buildPath('layout.phtml'),
        'account/password-reset-request'  => buildPath('account/password-reset-request.phtml'),
        'messaging/generic-message'       => buildPath('messaging/generic-message.phtml'),
        'messaging/save-the-date'         => buildPath('messaging/save-the-date.phtml'),
        'messaging/admin-daily-schedule'  => buildPath('messaging/admin-daily-schedule.phtml'),
        'messaging/guide-weekly-schedule' => buildPath('messaging/guide-weekly-schedule.phtml'),
        'messaging/guide-future-schedule' => buildPath('messaging/guide-future-schedule.phtml'),
        'messaging/admin-weekly-notes'    => buildPath('messaging/admin-weekly-notes.phtml')
    ],
    /**
     * These are basic restrictions to the rest-api, any rest-api controllers listed in these
     * arrays are restricted to admin usage only.  Note: ALL 'DELETE' requests are automatically
     * restricted to admin
     */
    'api-restrictions' => [
        'DELETE' => [],
        /** Get One or Many Objects */
        'GET'  => [
            'API\Controller\EmailMessage' => [],
            'API\Controller\DayType' => [],
            'API\Controller\Seasons' => [],
            'API\Controller\Shifts' => [],
            'API\Controller\Tasks' => [],
            'API\Controller\WeekdayAssignments' => [],
            'API\Controller\ShiftAssignments' => [],
            'API\Controller\ReservedDates' => [],
            'API\Controller\GuideShiftAssignments' => [],
            'API\Controller\Availabilities' => [],
            'API\Controller\EmailTemplate' => [],
            'API\Controller\TicketReconciliationMap' => [],
                                                                                  /* no identity required: must equal : value */
            'API\Controller\AutomatedEmail' => [ 'getExceptions' => [ 'apiKey' => 'false:equals:237bd46078906171e66628ffbc4842afda29dfad' ]]
        ],
        /** Update Existing Objects */
        'PUT'  => [
            'API\Controller\EmailMessage' => [],
            'API\Controller\TaskType' => [],
            'API\Controller\TourType' => [],
            'API\Controller\Organizations' => [],
            'API\Controller\DayType' => [],
            'API\Controller\Seasons' => [],
            'API\Controller\Shifts' => [],
            'API\Controller\Tasks' => [],
            'API\Controller\WeekdayAssignments' => [],
            'API\Controller\ShiftAssignments' => [],
            'API\Controller\GuideAvailabilities' => [],
            'API\Controller\ReservedDates' => [],
            'API\Controller\GuideShiftAssignments' => [],
            'API\Controller\Availabilities' => [],
            'API\Controller\TaskAssignment' => [],
            'API\Controller\TicketTypes' => [],
            'API\Controller\EmailTemplate' => [],
            'API\Controller\AutomatedEmail' => []
        ],
        /** Create New Objects */
        'POST' => [
            'API\Controller\EmailMessage' => [],
            'API\Controller\User' => [],
            'API\Controller\TaskType' => [],
            'API\Controller\TourType' => [],
            'API\Controller\Organizations' => [],
            'API\Controller\DayType' => [],
            'API\Controller\Seasons' => [],
            'API\Controller\Shifts' => [],
            'API\Controller\Tasks' => [],
            'API\Controller\WeekdayAssignments' => [],
            'API\Controller\ShiftAssignments' => [],
            'API\Controller\GuideAvailabilities' => [],
            'API\Controller\ReservedDates' => [],
                                                                    /* identity required: execute test function: is_array() */
            'API\Controller\GuideShiftAssignments' => [ 'postExceptions' => [ 'assignmentIds' => 'true:function:is_array' ]],
            'API\Controller\Availabilities' => [],
            'API\Controller\TaskAssignment' => [],
            'API\Controller\TicketTypes' => [],
            'API\Controller\EmailTemplate' => [],
            'API\Controller\AutomatedEmail' => []
        ],

    ],
    /**
     * recaptcha
     */
    // 'google_captcha' => [
    //     'site_key'   => '6Lcb7fsUAAAAAFjQ6dZvPFGVdoLJW058Rhf3_GlB',
    //     'secret_key' => '6Lcb7fsUAAAAAChVX_bVzEdGS5Ov6Y4YqWTdIl21',
    //     'api_url'    => 'https://www.google.com/recaptcha/api/siteverify'
    // ]
    // 'google_captcha' => [
    //     'site_key'   => '6Lduz9UpAAAAAFg-8bInumEyR-VkXMKpHiwoChnW',
    //     'secret_key' => '6Lduz9UpAAAAAEPqE6pF9OKb-NOsN4bQ6vqGqkck',
    //     'api_url'    => 'https://www.google.com/recaptcha/api/siteverify'
    // ],
    'google_captcha' => [
        'site_key'   => '6Lf_AxQsAAAAAEnoQMZKGPqs8WLWcVvZE7p3U-0-',
        'secret_key' => '6Lf_AxQsAAAAAGE9gUv8LjqOEEf1V4owpoy0BLr2',
        'api_url'    => 'https://www.google.com/recaptcha/api/siteverify'
    ],
];
